import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/navigator.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/set1/schedule.dart';

class SumTimelineNotification {
  String sumTimelineNotification;
  String employeeID;
  String authenKey;

  SumTimelineNotification(
      {this.sumTimelineNotification, this.employeeID, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumTimelineNotification_ReadList +
            "?SumTimelineNotification=" +
            AppUrl.SumTimelineNotification +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumTimelineNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    DateTime sumTimelineNotification,
  ) async {
    Map<String, dynamic> data = {
      "SumTimelineNotification": sumTimelineNotification,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumTimelineNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    DateTime sumTimelineNotification,
    String employeeID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumTimelineNotification": sumTimelineNotification,
      "EmployeeID": employeeID,
      "AuthenKey": authenKey,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumTimelineNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumTimelineNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumTimelineNotification.fromJson(Map<String, dynamic> json) {
    sumTimelineNotification = json['SumTimelineNotification'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumTimelineNotification'] = this.sumTimelineNotification;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
