import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumNewsNotification {
  String sumNewsNotification;
  String employeeID;
  String authenKey;

  SumNewsNotification(
      {this.sumNewsNotification, this.employeeID, this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumNewsNotification_ReadList +
            "?SumNewsNotification=" +
            AppUrl.SumNewsNotification +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumNewsNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String sumNewsNotification,
  ) async {
    Map<String, dynamic> data = {
      "SumNewsNotification": sumNewsNotification,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumNewsNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String sumNewsNotification,
    String employeeID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "SumNewsNotification": sumNewsNotification,
      "EmployeeID": employeeID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumNewsNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumNewsNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumNewsNotification.fromJson(Map<String, dynamic> json) {
    sumNewsNotification = json['SumNewsNotification'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['SumNewsNotification'] = this.sumNewsNotification;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
