import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumElectricShutdownNotification {
  String employeeID;
  String cAIDSumEletricShutdownNotificationID;
  String authenKey;

  SumElectricShutdownNotification(
      {this.employeeID,
      this.cAIDSumEletricShutdownNotificationID,
      this.authenKey});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumElectricShutdownNotification_ReadList +
            "?EmployeeID=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumElectricShutdownNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String employeeID,
  ) async {
    Map<String, dynamic> data = {
      "EmployeeID": employeeID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumElectricShutdownNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String employeeID,
    String cAIDSumEletricShutdownNotificationID,
    String authenKey,
  ) async {
    Map<String, dynamic> data = {
      "EmployeeID": employeeID,
      "CAIDSumEletricShutdownNotificationID":
          cAIDSumEletricShutdownNotificationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumElectricShutdownNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumElectricShutdownNotification> data =
      []; // ตัวแปรที่จะเรียกใช้งาน

  SumElectricShutdownNotification.fromJson(Map<String, dynamic> json) {
    employeeID = json['EmployeeID'];
    cAIDSumEletricShutdownNotificationID =
        json['CAIDSumEletricShutdownNotificationID'];
    authenKey = json['AuthenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['EmployeeID'] = this.employeeID;
    data['CAIDSumEletricShutdownNotificationID'] =
        this.cAIDSumEletricShutdownNotificationID;
    data['AuthenKey'] = this.authenKey;
    return data;
  }
}
