import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumCustomerRelationNotification {
  String customerID;
  String employeeID;
  String authenKey;
  String sumCustomerRelationNotification;

  SumCustomerRelationNotification(
      {this.customerID,
      this.employeeID,
      this.authenKey,
      this.sumCustomerRelationNotification});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumCustomerRelationNotification_ReadList +
            "?CustomerID=" +
            AppUrl.CustomerID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<SumCustomerRelationNotification> data =
      []; // ตัวแปรที่จะเรียกใช้งาน

  SumCustomerRelationNotification.fromJson(Map<String, dynamic> json) {
    customerID = json['CustomerID'];
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
    sumCustomerRelationNotification = json['SumCustomerRelationNotification'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CustomerID'] = this.customerID;
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    data['SumCustomerRelationNotification'] =
        this.sumCustomerRelationNotification;
    return data;
  }
}
