import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class SumChatNotification {
  String employeeID;
  String authenKey;
  String sumChatNotification;

  SumChatNotification(
      {this.employeeID, this.authenKey, this.sumChatNotification});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SumChatNotification_ReadList +
            "?EmployeeID=" +
            AppUrl.EmployeeID +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SumChatNotification_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String employeeID,
  ) async {
    Map<String, dynamic> data = {
      "EmployeeID": employeeID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumChatNotification_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String employeeID,
    String authenKey,
    String sumChatNotification,
  ) async {
    Map<String, dynamic> data = {
      "EmployeeID": employeeID,
      "SumChatNotification": sumChatNotification,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SumChatNotification_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SumChatNotification> data = []; // ตัวแปรที่จะเรียกใช้งาน

  SumChatNotification.fromJson(Map<String, dynamic> json) {
    employeeID = json['EmployeeID'];
    authenKey = json['AuthenKey'];
    sumChatNotification = json['SumChatNotification'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['EmployeeID'] = this.employeeID;
    data['AuthenKey'] = this.authenKey;
    data['SumChatNotification'] = this.sumChatNotification;
    return data;
  }
}
