import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';


class SearchPeaSmartCareRegisterinfo {
  String customerName;
  String registerStartdate;
  String registerEnddaate;
  String telephoneNumber;
  String oS;
  String deviceID;
  String name;
  String contact;
  String createDate;
  String iMEINo;
  String oSName;
  String versionNo;

  SearchPeaSmartCareRegisterinfo(
      {this.customerName,
      this.registerStartdate,
      this.registerEnddaate,
      this.telephoneNumber,
      this.oS,
      this.deviceID,
      this.name,
      this.contact,
      this.createDate,
      this.iMEINo,
      this.oSName,
      this.versionNo});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.SearchPeaSmartCareRegisterinfo_ReadList +
            "?CustomerName=" +
            AppUrl.CustomerName +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.SearchPeaSmartCareRegisterinfo_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String customerName,
  ) async {
    Map<String, dynamic> data = {
      "CustomerName": customerName,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SearchPeaSmartCareRegisterinfo_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String customerName,
    DateTime register_Startdate,
    DateTime register_Enddaate,
    String telephoneNumber,
    String oS,
    String deviceID,
    String name,
    String contact,
    DateTime createDate,
    String iMEINo,
    String oSName,
    String versionNo,
  ) async {
    Map<String, dynamic> data = {
      "CustomerName": customerName,
      "Register_Startdate": register_Startdate,
      "Register_Enddaate": register_Enddaate,
      "TelephoneNumber": telephoneNumber,
      "OS": oS,
      "DeviceID": deviceID,
      "Name": name,
      "Contact": contact,
      "CreateDate": createDate,
      "IMEINo": iMEINo,
      "OSName": oSName,
      "VersionNo": versionNo,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.SearchPeaSmartCareRegisterinfo_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<SearchPeaSmartCareRegisterinfo> data =
      []; // ตัวแปรที่จะเรียกใช้งาน

  SearchPeaSmartCareRegisterinfo.fromJson(Map<String, dynamic> json) {
    customerName = json['CustomerName'];
    registerStartdate = json['Register_Startdate'];
    registerEnddaate = json['Register_Enddaate'];
    telephoneNumber = json['TelephoneNumber'];
    oS = json['OS'];
    deviceID = json['DeviceID'];
    name = json['Name'];
    contact = json['Contact'];
    createDate = json['CreateDate'];
    iMEINo = json['IMEINo'];
    oSName = json['OSName'];
    versionNo = json['VersionNo'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['CustomerName'] = this.customerName;
    data['Register_Startdate'] = this.registerStartdate;
    data['Register_Enddaate'] = this.registerEnddaate;
    data['TelephoneNumber'] = this.telephoneNumber;
    data['OS'] = this.oS;
    data['DeviceID'] = this.deviceID;
    data['Name'] = this.name;
    data['Contact'] = this.contact;
    data['CreateDate'] = this.createDate;
    data['IMEINo'] = this.iMEINo;
    data['OSName'] = this.oSName;
    data['VersionNo'] = this.versionNo;
    return data;
  }
}
