import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class Privilage {
  String privailageID;
  String privailageName;
  String privailageSurName;
  String affiliationID;
  String phoneNumber;
  String oS;
  String registerStartDate;
  String registerEndDate;
  String privailageFullName;
  String position;
  String iMEI;
  String version;

  Privilage(
      {this.privailageID,
      this.privailageName,
      this.privailageSurName,
      this.affiliationID,
      this.phoneNumber,
      this.oS,
      this.registerStartDate,
      this.registerEndDate,
      this.privailageFullName,
      this.position,
      this.iMEI,
      this.version});

  static getData() async {
    final response = await AppApi.apiGetRequest(AppUrl.Privilage_ReadList +
        "?PrivailageID=" +
        AppUrl.PrivailageID +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response =
        await AppApi.post(AppUrl.Privilage_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String privailageID,
  ) async {
    Map<String, dynamic> data = {
      "PrivailageID": privailageID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Privilage_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String privailageID,
    String privailageName,
    String privailageSurName,
    String affiliationID,
    String phoneNumber,
    String oS,
    DateTime registerStartDate,
    DateTime registerEndDate,
    String privailageFullName,
    String position,
    String iMEI,
    String version,
  ) async {
    Map<String, dynamic> data = {
      "PrivailageID": privailageID,
      "PrivailageName": privailageName,
      "PrivailageSurName": privailageSurName,
      "AffiliationID": affiliationID,
      "PhoneNumber": phoneNumber,
      "OS": oS,
      "RegisterStartDate": registerStartDate,
      "RegisterEndDate": registerEndDate,
      "PrivailageFullName": privailageFullName,
      "Position": position,
      "IMEI": iMEI,
      "Version": version,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response =
        await AppApi.post(AppUrl.Privilage_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<Privilage> data = []; // ตัวแปรที่จะเรียกใช้งาน

  Privilage.fromJson(Map<String, dynamic> json) {
    privailageID = json['PrivailageID'];
    privailageName = json['PrivailageName'];
    privailageSurName = json['PrivailageSurName'];
    affiliationID = json['AffiliationID'];
    phoneNumber = json['PhoneNumber'];
    oS = json['OS'];
    registerStartDate = json['RegisterStartDate'];
    registerEndDate = json['RegisterEndDate'];
    privailageFullName = json['PrivailageFullName'];
    position = json['Position'];
    iMEI = json['IMEI'];
    version = json['Version'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['PrivailageID'] = this.privailageID;
    data['PrivailageName'] = this.privailageName;
    data['PrivailageSurName'] = this.privailageSurName;
    data['AffiliationID'] = this.affiliationID;
    data['PhoneNumber'] = this.phoneNumber;
    data['OS'] = this.oS;
    data['RegisterStartDate'] = this.registerStartDate;
    data['RegisterEndDate'] = this.registerEndDate;
    data['PrivailageFullName'] = this.privailageFullName;
    data['Position'] = this.position;
    data['IMEI'] = this.iMEI;
    data['Version'] = this.version;
    return data;
  }
}
