import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/loader.dart';

class PackageRequestHistory {
  String id;
  String pRId;
  String cA;
  int pStatusType;
  String pHDescreption;
  String createBy;
  String createDate;
  String statusType;

  PackageRequestHistory(
      {this.id,
      this.pRId,
      this.cA,
      this.pStatusType,
      this.pHDescreption,
      this.createBy,
      this.statusType,
      this.createDate});

  static getData() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.PackageRequestHistory_ReadList +
            "?AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getHistoryData() async {
    print(
        "urlHistory= ${AppUrl.PackageRequestHistory_ReadList + "?CA=" + AppUrl.CA + "&authenKey=" + AppUrl.AuthenKey}");
    final response = await AppApi.apiGetRequest(
        AppUrl.PackageRequestHistory_ReadList +
            "?CA=" +
            AppUrl.CA +
            "&authenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static getDataByCA() async {
    final response = await AppApi.apiGetRequest(
        AppUrl.PackageRequestHistory_CAReadList +
            "?CA=" +
            AppUrl.CA +
            "&AuthenKey=" +
            AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    print("saveData = $data");
    print(AppUrl.PackageRequestHistory_Create);
    final response = await AppApi.post(
        AppUrl.PackageRequestHistory_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      AppLoader.showSuccess('บันทึกเรียบร้อย');
      if (data.containsKey("AutoPushBack")) {
        if (data["AutoPushBack"] == "true") {
          data.remove("AutoPushBack");
          Navigator.of(context).pop(true);
        } else {
          data.remove("AutoPushBack");
        }
      } else {
        Navigator.of(context).pop(true);
      }
    } else {
      AppLoader.showError('บันทึกไม่สำเร็จ');
    }
  }

  static deleteData(
    context,
    String id,
  ) async {
    Map<String, dynamic> data = {"Id": id, "AuthenKey": AppUrl.AuthenKey};
    final response = await AppApi.post(
        AppUrl.PackageRequestHistory_Delete, data); // เรียกใช้ api
    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
    context,
    String id,
    String pRID,
    String cA,
    int pStatusType,
    String pHDescreption,
    String createBy,
    String createDate,
  ) async {
    Map<String, dynamic> data = {
      "Id": id,
      "PR_Id": pRID,
      "CA": cA,
      "P_StatusType": pStatusType,
      "PH_Descreption": pHDescreption,
      "CreateBy": createBy,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.PackageRequestHistory_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<PackageRequestHistory> data = []; // ตัวแปรที่จะเรียกใช้งาน

  PackageRequestHistory.fromJson(Map<String, dynamic> json) {
    id = json['Id'];
    pRId = json['PR_Id'];
    cA = json['CA'];
    pStatusType = json['P_StatusType'];
    pHDescreption = json['PH_Descreption'];
    createBy = json['CreateBy'];
    createDate = json['strCreateDate'];
    statusType = json['StatusType'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['Id'] = this.id;
    data['PR_Id'] = this.pRId;
    data['CA'] = this.cA;
    data['P_StatusType'] = this.pStatusType;
    data['PH_Descreption'] = this.pHDescreption;
    data['CreateBy'] = this.createBy;
    data['CreateDate'] = this.createDate;
    data['StatusType'] = this.statusType;
    return data;
  }
}
