import 'package:mwf_app/service/notification_count.dart';
import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';

class NotificationModel {
  String notificationId;
  String employeeID;
  String notificationType;
  String notificationTitle;
  String eventDate;
  String authenKey;
  String notificationRefId;
  String detail;
  String customerName;

  NotificationModel(
      {this.notificationId,
      this.employeeID,
      this.notificationType,
      this.notificationTitle,
      this.notificationRefId,
      this.detail,
      this.eventDate,
      this.authenKey,
      this.customerName,
    });

  static Future getData() async {
    // print(AppUrl.Notification_ReadList +
    //     "?employeeId=" +
    //     AppUrl.userEmployeeId +
    //     "&AuthenKey=" +
    //     AppUrl.AuthenKey);
    // final response = await AppApi.apiGetRequest(AppUrl.Notification_ReadList +
    //     "?employeeId=" +
    //     AppUrl.userEmployeeId +
    //     "&AuthenKey=" +
    //     AppUrl.AuthenKey); // เรียกใช้ api
    AppUrl.userEmployeeId =  NotificationCount.getPrefString('EmployeeID');
    final response = await AppApi.apiGetRequest(AppUrl.Notification_ReadList +
        "?employeeId=" +
        AppUrl.userEmployeeId +
        "&AuthenKey=" +
        AppUrl.AuthenKey); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    return response;
  }

  static List<dynamic> notificationTest = [
    {
      "index": 0,
      "detail": "นัดเยี่ยมเยือนลูกค้า สหการประมูล",
      "date": "14/02/2563 11:00 - 15/02/2563 14:00"
    },
    {
      "index": 1,
      "detail": "สัมนาเรื่องพลังงานทางเลือก และพลังงานทดแทน",
      "date": "11/02/2563 11:00"
    },
  ]; // รายการข่าวประชาสัมพันธ์

  static List<NotificationModel> data = []; // ตัวแปรที่จะเรียกใช้งาน

  NotificationModel.fromJson(Map<String, dynamic> json) {
    notificationId = json['NotificationID'];
    employeeID = json['EmployeeID'];
    notificationType = json['NotificationType'];
    notificationTitle = json['NotificationTitle'];
    eventDate = json['EventDate'];
    detail = json['Detail'];
    notificationRefId = json['NotificationRefId'];
    authenKey = json['authenKey'];
    customerName = json['CustomerName'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['NotificationId'] = this.notificationId;
    data['EmployeeID'] = this.employeeID;
    data['NotificationType'] = this.notificationType;
    data['NotificationTitle'] = this.notificationTitle;
    data['NotificationRefId'] = this.notificationRefId;
    data['EventDate'] = this.eventDate;
    data['Detail'] = this.detail;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
