import 'package:mwf_app/service/api.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/strings.dart';

class InstallElectricMeter {
  String ctValue;
  String vtValue;
  String installationNumber;
  String installationAddress;
  String authenKey;
  String peaNo;

  InstallElectricMeter({
    this.ctValue,
    this.vtValue,
    this.installationNumber,
    this.installationAddress,
    this.authenKey,
  });

  static getData() async {
    final response = await AppApi.apiGetRequest(
      AppUrl.InstallElectricMeter_ReadList +
          "?ca=" +
          AppStrings.serviceElectricityUserNumberName +
          "&AuthenKey=" +
          AppUrl.AuthenKey,
    ); // เรียกใช้ api
    data.clear(); // เคลียข้อมูลเดิมออกก่อน
    print(response);
    return response;
  }

  static saveData(context, Map<String, dynamic> data) async {
    final response = await AppApi.post(
        AppUrl.InstallElectricMeter_Create, data); // เรียกใช้ api
    print(response);
    if (response['statusCode'] == 200) {
      //Nav.push(context, Schedule());
    }
  }

  static deleteData(
    context,
    String installationID,
  ) async {
    Map<String, dynamic> data = {
      "InstallationID": installationID,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.InstallElectricMeter_Delete, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static updateData(
      context,
      String installationID,
      String cTValue,
      String installationNumber,
      String vTNumber,
      String installationAddress,
      String peaNum) async {
    Map<String, dynamic> data = {
      "InstallationID": installationID,
      "InstallNumber": installationNumber,
      "CTNumber": cTValue,
      "VTNumber": vTNumber,
      "peaNo": peaNum,
      "InstallationAddress": installationAddress,
      "AuthenKey": AppUrl.AuthenKey
    };
    final response = await AppApi.post(
        AppUrl.InstallElectricMeter_Update, data); // เรียกใช้ api

    if (response['statusCode'] == 200) {
      return true;
    } else {
      return false;
    }
  }

  static List<InstallElectricMeter> data = []; // ตัวแปรที่จะเรียกใช้งาน

  InstallElectricMeter.fromJson(Map<String, dynamic> json) {
    ctValue = json['CtValue'];
    if (ctValue == null) {
      ctValue = "-";
    }
    vtValue = json['VtValue'];
    if (vtValue == null) {
      vtValue = "-";
    }
    peaNo = json['peaNo'];
    installationNumber = json['InstallationNumber'];
    installationAddress = json['InstallationAddress'];
    authenKey = json['authenKey'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['CtValue'] = this.ctValue;
    data['VtValue'] = this.vtValue;
    data['peaNo'] = this.peaNo;
    data['InstallationNumber'] = this.installationNumber;
    data['InstallationAddress'] = this.installationAddress;
    data['authenKey'] = this.authenKey;
    return data;
  }
}
