import 'package:flutter/material.dart';

import 'package:mwf_app/model/Permission_model.dart';
import 'package:mwf_app/service/notification_count.dart';

import 'package:mwf_app/service/pref.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/strings.dart';

import 'package:mwf_app/home.dart';
import 'package:mwf_app/set9/login.dart';

class CheckLogin extends StatefulWidget {
  @override
  _CheckLoginState createState() => _CheckLoginState();
}

class _CheckLoginState extends State<CheckLogin> {
  bool loginStatus;
  String profileFullName;
  String profilePosition;
  String profilePositionName;
  void initState() {
    super.initState();
    check();
  }

  check() async {
    await getLogin();
    if (AppUrl.EmpID != null && AppUrl.EmpID.isEmpty && AppUrl.AuthenKey == null) {
      loginStatus = false;
    } else {
      profileFullName = await getPref('string', 'profileFullName');
      profilePosition = await getPref('string', 'profilePosition');
      profilePositionName = await getPref('string', 'profilePositionName');
      if (profileFullName != null ||
          profilePosition != null ||
          profilePositionName != null) {
        AppStrings.profileFullName = profileFullName;
        AppStrings.profilePosition = profilePosition;
        AppStrings.profilePositionName = profilePositionName;
      }
      loginStatus != true
          ? Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                builder: (context) => Login(),
              ),
            )
          : Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                builder: (context) => HomePage(),
              ),
            );
    }
  }

  getLogin() async {
    loginStatus = NotificationCount.getPrefBool("loginStatus") != null ? 
      NotificationCount.getPrefBool("loginStatus") : false;
    AppUrl.AuthenKey = await getPref('string', 'AuthenKey');
    AppUrl.userEmployeeId = await getPref('string', 'EmployeeID');
    AppUrl.EmpID = await getPref('string', 'userID');
    AppUrl.userID = await getPref('string', 'userID');
    AppUrl.employeeEmpID = await getPref('string', 'EmpID');
    
    print("login status : $loginStatus");
    print("login AppUrl.userID : ${AppUrl.userID}");
    print("login AppUrl.EmpID : ${AppUrl.EmpID}");
    if(AppUrl.userID != null || loginStatus != false){
      await Permission.setStatus();
      await NotificationCount.getNumberFromCustomer(context);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container();
  }
}
