import 'package:get/get.dart';
import 'package:mwf_app/set9/login.dart';
import 'package:mwf_app/service/notification_count.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:shared_preferences/shared_preferences.dart';

setPref(type, name, value) async {
  SharedPreferences prefs = await SharedPreferences.getInstance();
  type == 'int'
      ? await prefs.setInt(name, value)
      : type == 'string' || type == 'String'
          ? await prefs.setString(name, value)
          : await prefs.setBool(name, value);
}

getPref(type, name) async {
  var value;
  SharedPreferences prefs = await SharedPreferences.getInstance();
  type == 'int'
      ? value = prefs.getInt(name)
      : type == 'string' || type == 'String'
          ? value = prefs.getString(name)
          : value = prefs.getBool(name);
  return value;
}

checkPref(String name) async {
  SharedPreferences prefs = await SharedPreferences.getInstance();
  bool checkValue = prefs.containsKey(name);
  return checkValue;
}

logout(context) async {
  await ManageNotify.unSubScribesNotifyTopic();
  SharedPreferences prefs = await SharedPreferences.getInstance();
  prefs.clear();
  var loginStatus = await getPref("bool", "loginStatus");
  await setPref("bool", "loginStatus", false);
  var status = await getPref("bool", "loginStatus");
  
  print("Login status : " + loginStatus.toString());
  print("After Logout status : " + status.toString());
  Get.offAll(Login());
}
