import 'package:flutter/material.dart';
import 'package:mwf_app/service/fontsize.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/strings.dart';
import 'package:mwf_app/service/url.dart';
import 'package:mwf_app/service/assets.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/screen/bottom_menu.dart';
import 'dart:convert';
import 'package:image_picker/image_picker.dart';
import 'package:file_picker/file_picker.dart';
import 'package:mwf_app/screen/bottom_menu_landscape.dart';
import 'package:mwf_app/set1/serve_customers.dart';
import 'package:mwf_app/set2/list_customer.dart';
import 'dart:io';
import 'package:get/get.dart';
import 'package:permission_handler/permission_handler.dart';

void getPage(page) {
  Get.offAll(page);
}

class Header {
  static var routes;
  static String currentPage = "";

  static checkPage(String page, context) {
    List<String> pagenameList = [
      "CustomerProperty",
      "VisitingPlanList",
      "ActivityRelationship",
      "OfferAdditionalList",
      "MapNavigationShow",
      "HistoryPayment",
      "HistoryPowerFailed",
      "ElectricStatistics",
      "Customerstaff_list",
      "Customer_representative_list",
      "service_pointOfMeter_user",
      "service_report_user",
      "ServiceQuestionUser",
      "SaveSurveyList",
      "contact_user",
      "service_Timeline"
    ];

    if (pagenameList.contains(page)) {
      print("Hit : " + page);
      Get.offAll(ServeCustomer());
    } else if (page == "ServeCustomer") {
      Get.to(ListCustomer());
    } else if (!pagenameList.contains(page)) {
      print(page + " Not in list");
      Navigator.of(context).pop();
    }
  }

  static header1(context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    AppUrl.userName = AppStrings.profileFullName;
    return Stack(
      children: <Widget>[
        Container(
          width: mediaQuery(context, 'w', 1125),
          height: _height < 600
              ? mediaQuery(context, 'h', 920)
              : mediaQuery(context, 'h', 1000),
          decoration: BoxDecoration(
            image: DecorationImage(
              image: AssetImage(
                AppAssets.bg_service_layer2,
              ),
              fit: BoxFit.cover,
            ),
          ),
          child: Container(
            margin: EdgeInsets.fromLTRB(mediaQuery(context, 'w', 60),
                mediaQuery(context, 'h', 320), mediaQuery(context, 'w', 60), 0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  alignment: Alignment.center,
                  child: Text(
                    AppStrings.service_service,
                    style: TextStyle(
                        fontSize:
                            mediaQuery(context, "h", AppFontSize.headText),
                        color: AppColors.color),
                  ),
                ),
                SizedBox(
                  height: mediaQuery(context, "h", 0),
                ),
                Text(
                  AppStrings.serviceCompanyName,
                  style: TextStyle(
                      fontWeight: FontWeight.bold,
                      fontSize: mediaQuery(context, "h", AppFontSize.headText2),
                      color: AppColors.color_serviceCompany),
                ),
                SizedBox(
                  height: mediaQuery(context, "h", 5),
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          "หมายเลขผู้ใช้ไฟ : ",
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize:
                                  mediaQuery(context, "w", AppFontSize.h3),
                              height: 2,
                              color: AppColors.color_serviceCompany),
                        ),
                        Text(
                          AppStrings.serviceElectricityUserNumberName,
                          style: TextStyle(
                              fontWeight: FontWeight.bold,
                              fontSize: mediaQuery(
                                  context, "w", AppFontSize.headText3),
                              height: 1,
                              color: AppColors.color_serviceCompanyDetail),
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      AppStrings.service_ElectricityUserAddressName +
                          "       : ",
                      style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: mediaQuery(context, "w", AppFontSize.h3),
                        height: 2,
                        color: AppColors.color_serviceCompany,
                      ),
                    ),
                    Flexible(
                      child: Text(
                        AppStrings.serviceElectricityUserAddress,
                        style: TextStyle(
                          fontWeight: FontWeight.bold,
                          fontSize: mediaQuery(context, "w", AppFontSize.h3),
                          height: 2,
                          color: AppColors.color_serviceCompanyDetail,
                        ),
                      ),
                    ),
                  ],
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          AppStrings.service_ElectricityUserTSIC +
                              "             : ",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompany,
                          ),
                        ),
                        Text(
                          AppStrings.serviceElectricityUserTSICDetail,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompanyDetail,
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          AppStrings.service_ElectricityName + "        : ",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompany,
                          ),
                        ),
                        Text(
                          AppStrings.serviceElectricityNameDetail,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompanyDetail,
                          ),
                        ),
                      ],
                    ),
                  ],
                )
              ],
            ),
          ),
        ),
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 450),
          child: Image.asset(
            AppAssets.bg_service,
            fit: BoxFit.cover,
          ),
        ),
        GestureDetector(
          onTap: () {
            print('Navigator.pop Full');
            Navigator.of(context).pop();
          },
          child: Container(
            color: Colors.transparent,
            margin: EdgeInsets.only(
              left: mediaQuery(context, 'w', 0),
              top: mediaQuery(context, 'h', 140),
            ),
            padding: EdgeInsets.all(
              mediaQuery(context, 'h', 20),
            ),
            child: Icon(
              Icons.arrow_back_ios,
              color: Colors.white,
              size: mediaQuery(context, 'h', 90),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 171), 0, 0),
          child: Text(
            AppStrings.profileFullName + " : " + AppStrings.profilePosition,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", AppFontSize.h2),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 231), 0, 0),
          child: Text(
            AppStrings.profilePositionName,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontSize: mediaQuery(context, "w", AppFontSize.h3),
            ),
          ),
        ),
        Container(
          width: mediaQuery(context, 'h', 177),
          height: _height < 600
              ? mediaQuery(context, 'h', 155)
              : mediaQuery(context, 'h', 177),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 130),
            left: mediaQuery(context, 'w', 940),
            right: mediaQuery(context, 'w', 30),
          ),
          decoration: BoxDecoration(
            shape: BoxShape.circle,
            border: Border.all(
              color: Colors.white,
              width: 2,
            ),
            image: DecorationImage(
              fit: BoxFit.cover,
              image: AssetImage(AppAssets.imageProfile),
            ),
          ),
        ),
      ],
    );
  }

  static header2(context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    return Stack(
      children: <Widget>[
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 450),
          child: Image.asset(
            AppAssets.bg_service,
            fit: BoxFit.cover,
          ),
        ),
        GestureDetector(
          onTap: () => Navigator.pop(context),
          child: Container(
            color: Colors.transparent,
            margin: EdgeInsets.only(
              left: mediaQuery(context, 'w', 0),
              top: mediaQuery(context, 'h', 140),
            ),
            padding: EdgeInsets.all(
              mediaQuery(context, 'h', 20),
            ),
            child: Icon(
              Icons.arrow_back_ios,
              color: Colors.white,
              size: mediaQuery(context, 'h', 90),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 171), 0, 0),
          child: Text(
            AppStrings.profileFullName + " : " + AppStrings.profilePosition,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", AppFontSize.h2),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 231), 0, 0),
          child: Text(
            AppStrings.profilePositionName,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontSize: mediaQuery(context, "w", AppFontSize.h3),
            ),
          ),
        ),
        Container(
          width: mediaQuery(context, 'h', 177),
          height: _height < 600
              ? mediaQuery(context, 'h', 155)
              : mediaQuery(context, 'h', 177),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 130),
            left: mediaQuery(context, 'w', 940),
            right: mediaQuery(context, 'w', 30),
          ),
          decoration: BoxDecoration(
            shape: BoxShape.circle,
            border: Border.all(
              color: Colors.white,
              width: 2,
            ),
            image: DecorationImage(
              fit: BoxFit.cover,
              image: AssetImage(AppAssets.imageProfile),
            ),
          ),
        ),
      ],
    );
  }

  static header2ListPage(context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    return Stack(
      children: <Widget>[
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 450),
          child: Image.asset(
            AppAssets.bg_service,
            fit: BoxFit.cover,
          ),
        ),
        GestureDetector(
          onTap: () {
            print('Navigator.pop header2');
            var page = routes;
            getPage(page);
          },
          child: Container(
            color: Colors.transparent,
            margin: EdgeInsets.only(
              left: mediaQuery(context, 'w', 0),
              top: mediaQuery(context, 'h', 140),
            ),
            padding: EdgeInsets.all(
              mediaQuery(context, 'h', 20),
            ),
            child: Icon(
              Icons.arrow_back_ios,
              color: Colors.white,
              size: mediaQuery(context, 'h', 90),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 171), 0, 0),
          child: Text(
            AppStrings.profileFullName + " : " + AppStrings.profilePosition,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", AppFontSize.h2),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 231), 0, 0),
          child: Text(
            AppStrings.profilePositionName,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontSize: mediaQuery(context, "w", AppFontSize.h3),
            ),
          ),
        ),
        Container(
          width: mediaQuery(context, 'h', 177),
          height: _height < 600
              ? mediaQuery(context, 'h', 155)
              : mediaQuery(context, 'h', 177),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 130),
            left: mediaQuery(context, 'w', 940),
            right: mediaQuery(context, 'w', 30),
          ),
          decoration: BoxDecoration(
            shape: BoxShape.circle,
            border: Border.all(
              color: Colors.white,
              width: 2,
            ),
            image: DecorationImage(
              fit: BoxFit.cover,
              image: AssetImage(AppAssets.imageProfile),
            ),
          ),
        ),
      ],
    );
  }

  static headerListPage(context) {
    // เมนูด้านบนแบบเต็ม
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    AppUrl.userName = AppStrings.profileFullName;
    return Stack(
      children: <Widget>[
        Container(
          width: mediaQuery(context, 'w', 1125),
          height: _height < 600
              ? mediaQuery(context, 'h', 920)
              : mediaQuery(context, 'h', 1000),
          decoration: BoxDecoration(
            image: DecorationImage(
              image: AssetImage(
                AppAssets.bg_service_layer2,
              ),
              fit: BoxFit.cover,
            ),
          ),
          child: Container(
            margin: EdgeInsets.fromLTRB(mediaQuery(context, 'w', 60),
                mediaQuery(context, 'h', 320), mediaQuery(context, 'w', 60), 0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Container(
                  alignment: Alignment.center,
                  child: Text(
                    AppStrings.service_service,
                    style: TextStyle(
                      fontSize: mediaQuery(context, "h", AppFontSize.headText),
                      color: AppColors.color,
                    ),
                  ),
                ),
                SizedBox(
                  height: mediaQuery(context, "h", 0),
                ),
                Text(
                  AppStrings.serviceCompanyName,
                  style: TextStyle(
                    fontWeight: FontWeight.bold,
                    fontSize: mediaQuery(context, "h", AppFontSize.headText2),
                    color: AppColors.color_serviceCompany,
                  ),
                ),
                SizedBox(
                  height: mediaQuery(context, "h", 5),
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          "หมายเลขผู้ใช้ไฟ : ",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompany,
                          ),
                        ),
                        Text(
                          AppStrings.serviceElectricityUserNumberName,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize:
                                mediaQuery(context, "w", AppFontSize.headText3),
                            height: 1,
                            color: AppColors.color_serviceCompanyDetail,
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Text(
                      AppStrings.service_ElectricityUserAddressName +
                          "       : ",
                      style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: mediaQuery(context, "w", AppFontSize.h3),
                        height: 2,
                        color: AppColors.color_serviceCompany,
                      ),
                    ),
                    Flexible(
                      child: Text(
                        AppStrings.serviceElectricityUserAddress,
                        style: TextStyle(
                          fontWeight: FontWeight.bold,
                          fontSize: mediaQuery(context, "w", AppFontSize.h3),
                          height: 2,
                          color: AppColors.color_serviceCompanyDetail,
                        ),
                      ),
                    ),
                  ],
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          AppStrings.service_ElectricityUserTSIC +
                              "             : ",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompany,
                          ),
                        ),
                        Text(
                          AppStrings.serviceElectricityUserTSICDetail,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompanyDetail,
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  children: <Widget>[
                    Row(
                      children: <Widget>[
                        Text(
                          AppStrings.service_ElectricityName + "        : ",
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompany,
                          ),
                        ),
                        Text(
                          AppStrings.serviceElectricityNameDetail,
                          style: TextStyle(
                            fontWeight: FontWeight.bold,
                            fontSize: mediaQuery(context, "w", AppFontSize.h3),
                            height: 2,
                            color: AppColors.color_serviceCompanyDetail,
                          ),
                        ),
                      ],
                    ),
                  ],
                )
              ],
            ),
          ),
        ),
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 450),
          child: Image.asset(
            AppAssets.bg_service,
            fit: BoxFit.cover,
          ),
        ),
        GestureDetector(
          onTap: () {
            print('Navigator.pop Full goto serve customer');
            var pageroute = routes;
            getPage(pageroute);
            //Get.offAll(ServeCustomer());
          },
          child: Container(
            color: Colors.transparent,
            margin: EdgeInsets.only(
              left: mediaQuery(context, 'w', 0),
              top: mediaQuery(context, 'h', 140),
            ),
            padding: EdgeInsets.all(
              mediaQuery(context, 'h', 20),
            ),
            child: Icon(
              Icons.arrow_back_ios,
              color: Colors.white,
              size: mediaQuery(context, 'h', 90),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 171), 0, 0),
          child: Text(
            AppStrings.profileFullName + " : " + AppStrings.profilePosition,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", AppFontSize.h2),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 240),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 231), 0, 0),
          child: Text(
            AppStrings.profilePositionName,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontSize: mediaQuery(context, "w", AppFontSize.h3),
            ),
          ),
        ),
        Container(
          width: mediaQuery(context, 'h', 177),
          height: _height < 600
              ? mediaQuery(context, 'h', 155)
              : mediaQuery(context, 'h', 177),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 130),
            left: mediaQuery(context, 'w', 940),
            right: mediaQuery(context, 'w', 30),
          ),
          decoration: BoxDecoration(
            shape: BoxShape.circle,
            border: Border.all(
              color: Colors.white,
              width: 2,
            ),
            image: DecorationImage(
              fit: BoxFit.cover,
              image: AssetImage(AppAssets.imageProfile),
            ),
          ),
        ),
      ],
    );
  }

  static headerLandscape(context) {
    double _width = MediaQuery.of(context).size.width;
    double _height = MediaQuery.of(context).size.height;
    AppUrl.userName = AppStrings.profileFullName;
    return Stack(
      children: <Widget>[
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 450),
          child: Image.asset(
            AppAssets.bg_service,
            fit: BoxFit.cover,
          ),
        ),
        GestureDetector(
          onTap: () {
            print('Navigator.pop Full');
            String page = context.toString().split("(")[0];
            checkPage(page, context);
          },
          child: Container(
            color: Colors.transparent,
            margin: EdgeInsets.only(
              left: mediaQuery(context, 'w', 10),
              top: mediaQuery(context, 'h', 140),
            ),
            padding: EdgeInsets.all(
              mediaQuery(context, 'h', 20),
            ),
            child: Icon(
              Icons.arrow_back_ios,
              color: Colors.white,
              size: mediaQuery(context, 'h', 200),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 10),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 140),
              mediaQuery(context, "h", 200), 0, 0),
          child: Text(
            "สถิติการใช้ไฟฟ้า",
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", 30),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 150),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 171), 0, 0),
          child: Text(
            AppStrings.profileFullName + " : " + AppStrings.profilePosition,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontWeight: FontWeight.bold,
              fontSize: mediaQuery(context, "w", 20),
            ),
          ),
        ),
        Container(
          margin: EdgeInsets.only(
            right: mediaQuery(context, 'w', 150),
          ),
          width: _width,
          padding: EdgeInsets.fromLTRB(mediaQuery(context, "w", 100),
              mediaQuery(context, "h", 260), 0, 0),
          child: Text(
            AppStrings.profilePositionName,
            textAlign: TextAlign.right,
            style: TextStyle(
              color: AppColors.color_profile,
              fontSize: mediaQuery(context, "w", 25),
            ),
          ),
        ),
        Container(
          width: mediaQuery(context, 'h', 177),
          height: _height < 600
              ? mediaQuery(context, 'h', 200)
              : mediaQuery(context, 'h', 177),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 190),
            left: mediaQuery(context, 'w', 1000),
            right: mediaQuery(context, 'w', 30),
          ),
          decoration: BoxDecoration(
            shape: BoxShape.circle,
            border: Border.all(
              color: Colors.white,
              width: 2,
            ),
            image: DecorationImage(
              fit: BoxFit.cover,
              image: AssetImage(AppAssets.imageProfile),
            ),
          ),
        ),
      ],
    );
  }

  static mainMenu(context) {
    double _width = MediaQuery.of(context).size.width;
    return Stack(
      children: <Widget>[
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 175),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 2267.16),
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topRight: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
            ),
            color: Color(0xFF7F3F98),
          ),
          child: BottomMenu(activePage: currentPage,),
        ),
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 121.87),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 2146),
          ),
          color: Color(0xFF7F3F98),
        ),
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 1000),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 1269.51),
          ),
          padding: EdgeInsets.fromLTRB(
            mediaQuery(context, 'w', 60),
            mediaQuery(context, 'w', 80),
            mediaQuery(context, 'w', 60),
            mediaQuery(context, 'w', 80),
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topLeft: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
            ),
            color: Color(0xFFf2f5f7),
          ),
        )
      ],
    );
  }

  static footermenuLandScape(context) {
    double _width = MediaQuery.of(context).size.width;
    return Stack(
      children: <Widget>[
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 260),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 2200.16),
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topRight: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
            ),
            color: Color(0xFF7F3F98),
          ),
          child: BottomMenuLandScape(),
        ),
        Container(
          width: _width,
          height: mediaQuery(context, 'h', 1000),
          margin: EdgeInsets.only(
            top: mediaQuery(context, 'h', 1200.51),
          ),
          padding: EdgeInsets.fromLTRB(
            mediaQuery(context, 'w', 60),
            mediaQuery(context, 'w', 80),
            mediaQuery(context, 'w', 60),
            mediaQuery(context, 'w', 80),
          ),
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topLeft: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
              bottomLeft: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
            ),
            color: Color(0xFFf2f5f7),
          ),
        )
      ],
    );
  }

  static mainMenu2(context, _text, _dataBase64Img, _selectImage,
      _dataBase64File, _selectDoc, _filename, imageFunction, fileFunction, function) {
    double _width = MediaQuery.of(context).size.width;
    return Stack(
      alignment: AlignmentDirectional.bottomCenter,
      children: <Widget>[
        Container(
          width: _width,
          color: Color(0xFFFFFFFF),
        ),
        Container(
          width: _width,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
              topRight: Radius.circular(
                mediaQuery(context, 'h', 100),
              ),
            ),
            color: Color(0xFFFFFFFF),
          ),
          child: bottomChat(
            context,
            _text,
            _dataBase64Img,
            _selectImage,
            _dataBase64File,
            _selectDoc,
            _filename,
            imageFunction,
            fileFunction,
            function,
          ),
        ),
      ],
    );
  }

  static bottomChat(context, _text, _dataBase64Img, _selectImage,
      _dataBase64File, _selectDoc, _filename, imageFunction, fileFunction, function) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: <Widget>[
        IconButton(
          icon: Image.asset(
            AppAssets.iconsplus,
            width: mediaQuery(context, 'w', 80),
          ),
          onPressed: () {
            openFile(_selectDoc, _dataBase64File, _filename, fileFunction);
          },
        ),
        IconButton(
          icon: Image.asset(
            AppAssets.icn_camera_active,
            width: mediaQuery(context, 'w', 80),
          ),
          onPressed: () =>
              openCamera(_selectImage, _dataBase64Img, _filename, imageFunction),
        ),
        IconButton(
          icon: Image.asset(
            AppAssets.iconpicture,
            width: mediaQuery(context, 'w', 80),
          ),
          onPressed: () =>
              openGallery(_selectImage, _dataBase64Img, _filename, imageFunction),
        ),
        Container(
          width: mediaQuery(context, 'w', 700),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(35.0),
            boxShadow: [
              BoxShadow(offset: Offset(0, 3), blurRadius: 5, color: Colors.grey)
            ],
          ),
          child: TextField(
            maxLines: null,
            controller: _text,
            textAlignVertical: TextAlignVertical.center,
            decoration: InputDecoration(
              focusedBorder: InputBorder.none,
              border: InputBorder.none,
              suffixIcon: IconButton(
                icon: Icon(
                  Icons.send,
                  color: AppColors.color,
                ),
                onPressed: function,
              ),
              hintText: "Write a message...",
              contentPadding: EdgeInsets.only(
                left: mediaQuery(context, 'w', 30),
                //bottom: mediaQuery(context, 'h', 30),
              ),
            ),
          ),
        ),
      ],
    );
  }
}

String base64Doc;
int filesize = 0;

final picker = ImagePicker();

Future openCamera(_selectImage, _dataBase64Img, _filename, function) async {
  final status = await Permission.camera.status;
  final PickedFile pickedFile = await picker.getImage(source: ImageSource.camera);
  if(status.isGranted){
    File imageCamera = pickedFile == null ? null: File(pickedFile.path);
    if (imageCamera != null) {
      String base64 = base64Encode(imageCamera.readAsBytesSync());
      filesize = imageCamera.lengthSync();
    var getType = imageCamera.path.split("/")[imageCamera.path.split("/").length - 1].split(".")[1];
      _filename.text = imageCamera.path.split("/")[imageCamera.path.split("/").length - 1];
      _selectImage.text = getType;
      _dataBase64Img.text = base64;
      print(_selectImage.text);
      await function();
    }

  }else{
    print("I dont know");
  }
}

Future openGallery(_selectImage, _dataBase64Img, _filename, function) async {
  final PickedFile pickedFile =
      await picker.getImage(source: ImageSource.gallery);
  File imageGallery = pickedFile == null ? null : File(pickedFile.path);
  if (imageGallery != null) {
    String base64 = base64Encode(imageGallery.readAsBytesSync());
    filesize = imageGallery.lengthSync();
    _selectImage.text = imageGallery.path.split("/")[imageGallery.path.split("/").length - 1].split(".")[1];
    _filename.text = imageGallery.path.split("/")[imageGallery.path.split("/").length - 1];
    _dataBase64Img.text = base64;
    await function();
  }
}

Future openFile(_selectDoc, _dataBase64File, _filename, function) async {
  File file = await FilePicker.getFile();
  if (file != null) {
    String base64 = base64Encode(file.readAsBytesSync());
    filesize = file.lengthSync();
    _selectDoc.text = file.path.split("/")[file.path.split("/").length - 1].split(".")[1];
    base64Doc = base64;
    _filename.text = file.path.split("/")[file.path.split("/").length - 1];
    _dataBase64File.text = base64;
    await function();
  }
}
