import 'package:flutter/material.dart';
import 'package:mwf_app/service/screen.dart';
import 'package:mwf_app/service/color.dart';

class Form {
  static dropdown(context) {
    Container(
      height: mediaQuery(context, 'h', 130),
      width: mediaQuery(context, 'w', 1005),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(20),
          border: Border.all(
            color: Color(0xFF999C9D),
            width: 0.5,
          ),
          color: Colors.white),
      child: Container(
        margin: EdgeInsets.only(
          left: mediaQuery(context, 'w', 25),
        ),
        child: DropdownButton<String>(
//            value: dropdownValue,
            icon: Icon(Icons.expand_more),
            iconSize: 30,
            elevation: 16,
            style: TextStyle(color: AppColors.Black),
            underline: Container(
              height: 0,
              color: AppColors.Black,
            ),
            onChanged: (String newValue) {
//              setState(() {
//                dropdownValue = newValue;
//              });
            },
            items: <String>['One', 'Two', 'Free', 'Four']
                .map<DropdownMenuItem<String>>((String value) {
              return DropdownMenuItem<String>(
                value: value,
                child: Text(value),
              );
            }).toList(),
            isExpanded: true),
      ),
    );
  }
}
