import 'package:flutter/material.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:mwf_app/service/color.dart';
import 'package:mwf_app/service/screen.dart';

checkForm(array) async {
  for (var i = 0; i < array.length; i++) {
    if (array[i].isEmpty || array[i] == 'เลือก' || array[i] == '') {
      return false;
    }
  }

  return true;
}

alertForm(context, title, message) {
  return showDialog(
    barrierDismissible: false,
    context: context,
    builder: (BuildContext context) {
      return Center(
        child: AlertDialog(
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.all(
              Radius.circular(
                mediaQuery(context, 'h', 50),
              ),
            ),
          ),
          title: Column(
            children: <Widget>[
              Container(
                child: Icon(
                  FontAwesomeIcons.exclamationCircle,
                  size: mediaQuery(context, 'h', 240),
                  color: AppColors.color,
                ),
              ),
            ],
          ),
          content: Container(
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Text(
                  title,
                  style: TextStyle(
                    fontWeight: FontWeight.bold,
                    fontSize: mediaQuery(context, 'h', 60),
                  ),
                  textAlign: TextAlign.center,
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 10),
                ),
                Text(
                  message,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 46),
                  ),
                  textAlign: TextAlign.center,
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 40),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  children: <Widget>[
                    ButtonTheme(
                      minWidth: mediaQuery(context, 'h', 320),
                      height: mediaQuery(context, 'h', 120),
                      child: RaisedButton(
                        color: Colors.white,
                        shape: new RoundedRectangleBorder(
                          borderRadius: new BorderRadius.circular(
                            mediaQuery(context, 'h', 50),
                          ),
                          side: BorderSide(
                            color: AppColors.color.withOpacity(0.51),
                          ),
                        ),
                        onPressed: () {
                          Navigator.pop(context);
                        },
                        splashColor: AppColors.color,
                        child: Text(
                          'ตกลง',
                          style: TextStyle(
                            color: AppColors.color,
                            fontSize: mediaQuery(context, 'h', 46),
                          ),
                        ),
                      ),
                    ),
//                    SizedBox(
//                      width: mediaQuery(context, 'w', 20),
//                    ),
//                    ButtonTheme(
//                      minWidth: mediaQuery(context, 'h', 320),
//                      height: mediaQuery(context, 'h', 120),
//                      child: RaisedButton(
//                        color: Colors.white,
//                        shape: new RoundedRectangleBorder(
//                          borderRadius: new BorderRadius.circular(
//                            mediaQuery(context, 'h', 50),
//                          ),
//                          side: BorderSide(
//                            color: AppColors.color.withOpacity(0.51),
//                          ),
//                        ),
//                        onPressed: () {
//                          Navigator.pop(context);
//                        },
//                        splashColor: AppColors.color,
//                        child: Text(
//                          "ยกเลิก",
//                          style: TextStyle(
//                            color: AppColors.color,
//                            fontSize: mediaQuery(context, 'h', 46),
//                          ),
//                        ),
//                      ),
//                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      );
    },
  );
}

alertConfirm(context, title, message) {
  return showDialog(
    barrierDismissible: false,
    context: context,
    builder: (BuildContext context) {
      return Center(
        child: AlertDialog(
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.all(
              Radius.circular(
                mediaQuery(context, 'h', 50),
              ),
            ),
          ),
          title: Column(
            children: <Widget>[
              Container(
                child: Icon(
                  FontAwesomeIcons.exclamationCircle,
                  size: mediaQuery(context, 'h', 240),
                  color: AppColors.color,
                ),
              ),
            ],
          ),
          content: Container(
            width: mediaQuery(context, 'w', 500),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                Text(
                  title,
                  style: TextStyle(
                    fontWeight: FontWeight.bold,
                    fontSize: mediaQuery(context, 'h', 60),
                  ),
                  textAlign: TextAlign.center,
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 80),
                ),
                Text(
                  message,
                  style: TextStyle(
                    fontSize: mediaQuery(context, 'h', 46),
                  ),
                  textAlign: TextAlign.center,
                ),
                SizedBox(
                  height: mediaQuery(context, 'h', 70),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  children: <Widget>[
                    ButtonTheme(
                      minWidth: mediaQuery(context, 'h', 320),
                      height: mediaQuery(context, 'h', 120),
                      child: RaisedButton(
                        color: Colors.white,
                        shape: new RoundedRectangleBorder(
                          borderRadius: new BorderRadius.circular(
                            mediaQuery(context, 'h', 50),
                          ),
                          side: BorderSide(
                            color: AppColors.color.withOpacity(0.51),
                          ),
                        ),
                        onPressed: () {
                          Navigator.of(context).pop(true);
                        },
                        splashColor: AppColors.color,
                        child: Text(
                          'ตกลง',
                          style: TextStyle(
                            color: AppColors.color,
                            fontSize: mediaQuery(context, 'h', 46),
                          ),
                        ),
                      ),
                    ),
                    SizedBox(
                      width: mediaQuery(context, 'w', 20),
                    ),
                    ButtonTheme(
                      minWidth: mediaQuery(context, 'h', 320),
                      height: mediaQuery(context, 'h', 120),
                      child: RaisedButton(
                        color: Colors.white,
                        shape: new RoundedRectangleBorder(
                          borderRadius: new BorderRadius.circular(
                            mediaQuery(context, 'h', 50),
                          ),
                          side: BorderSide(
                            color: AppColors.color.withOpacity(0.51),
                          ),
                        ),
                        onPressed: () {
                          Navigator.of(context).pop(false);
                        },
                        splashColor: AppColors.color,
                        child: Text(
                          "ยกเลิก",
                          style: TextStyle(
                            color: AppColors.color,
                            fontSize: mediaQuery(context, 'h', 46),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      );
    },
  );
}
