import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/screen/term/term_page.dart';

class LoginPage extends StatefulWidget {
  const LoginPage({Key? key}) : super(key: key);

  @override
  _LoginPageState createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return GestureDetector(
      onTap: () {
        FocusScope.of(context).unfocus();
      },
      child: Scaffold(
        backgroundColor: Color.fromRGBO(241, 229, 253, 1),
        body: Column(
          children: [
            SizedBox(
              height: 50.h,
            ),
            Center(
              child: Image.asset(
                'assets/images/logo_login.png',
                fit: BoxFit.contain,
                height: 130,
                width: 130,
              ),
            ),
            Text(
              "ยินดีต้อนรับเข้าสู่ระบบ",
              style: TextStyle(
                color: Colors.black87,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
              ),
            ),
            Container(
              padding: EdgeInsets.only(left: 30, top: 30),
              alignment: Alignment.topLeft,
              child: Text(
                "Username",
                textAlign: TextAlign.left,
                style: TextStyle(
                  color: Color.fromRGBO(77, 32, 126, 1),
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
            Container(
              padding: EdgeInsets.only(left: 30, right: 30, top: 10),
              child: TextField(
                decoration: InputDecoration(
                    border: OutlineInputBorder(
                      borderRadius: BorderRadius.circular(30.0),
                    ),
                    filled: true,
                    prefixIcon: Icon(
                      Icons.search,
                      color: Color.fromRGBO(77, 32, 126, 1),
                    ),
                    contentPadding:
                        EdgeInsets.only(left: 14.0, bottom: 0.0, top: 8.0),
                    focusedBorder: OutlineInputBorder(
                      borderSide: BorderSide(color: Colors.transparent),
                      borderRadius: BorderRadius.circular(25.7),
                    ),
                    enabledBorder: UnderlineInputBorder(
                      borderSide: BorderSide(color: Colors.transparent),
                      borderRadius: BorderRadius.circular(25.7),
                    ),
                    hintStyle: TextStyle(
                      color: Colors.grey,
                      fontFamily: 'DBHeavent',
                      fontSize: 25,
                      fontWeight: FontWeight.w500,
                    ),
                    hintText: "Username",
                    fillColor: Colors.white),
              ),
            ),
            Container(
              padding: EdgeInsets.only(left: 30, top: 10),
              alignment: Alignment.topLeft,
              child: Text(
                "Password",
                textAlign: TextAlign.left,
                style: TextStyle(
                  color: Color.fromRGBO(77, 32, 126, 1),
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
            Container(
              padding: EdgeInsets.only(left: 30, right: 30, top: 10),
              child: TextField(
                decoration: InputDecoration(
                    border: OutlineInputBorder(
                      borderRadius: BorderRadius.circular(30.0),
                    ),
                    filled: true,
                    prefixIcon: Icon(
                      Icons.search,
                      color: Color.fromRGBO(77, 32, 126, 1),
                    ),
                    suffixIcon: Icon(
                      Icons.remove_red_eye_outlined,
                      color: Colors.grey,
                    ),
                    contentPadding: const EdgeInsets.only(
                        left: 14.0, bottom: 0.0, top: 8.0),
                    focusedBorder: OutlineInputBorder(
                      borderSide: BorderSide(color: Colors.transparent),
                      borderRadius: BorderRadius.circular(25.7),
                    ),
                    enabledBorder: UnderlineInputBorder(
                      borderSide: BorderSide(color: Colors.transparent),
                      borderRadius: BorderRadius.circular(25.7),
                    ),
                    hintStyle: TextStyle(
                      color: Colors.grey,
                      fontFamily: 'DBHeavent',
                      fontSize: 25,
                      fontWeight: FontWeight.w500,
                    ),
                    hintText: "Password",
                    fillColor: Colors.white),
              ),
            ),
            Container(
              padding: EdgeInsets.only(right: 30, top: 10),
              alignment: Alignment.topRight,
              child: Text(
                "ลืมรหัสผ่าน",
                textAlign: TextAlign.left,
                style: TextStyle(
                  decoration: TextDecoration.underline,
                  color: Color.fromRGBO(77, 32, 126, 1),
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
            _loginButton(),
            _fbButton(),
            SizedBox(
              height: 10.h,
            ),
            _registerButton(),
          ],
        ),
      ),
    );
  }

  Widget _loginButton() {
    return Padding(
      padding: EdgeInsets.only(left: 30, right: 30, top: 30),
      child: RaisedButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(30.0)),
        child: Container(
          alignment: Alignment.center,
          height: 40.h,
          width: double.infinity,
          child: Text(
            "เข้าสู่ระบบ",
            style: TextStyle(
              fontSize: 30,
              fontWeight: FontWeight.w500,
              fontFamily: 'DBHeavent',
              color: Colors.white,
            ),
          ),
        ),
        color: Color.fromRGBO(77, 32, 126, 1),
        onPressed: () {},
      ),
    );
  }

  Widget _fbButton() {
    return Padding(
      padding: EdgeInsets.only(left: 30, right: 30, top: 30),
      child: RaisedButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(30.0)),
        child: Container(
          alignment: Alignment.center,
          height: 40.h,
          width: double.infinity,
          child: Text(
            "f เข้าสู่ระบบผ่าน Facebook",
            style: TextStyle(
              fontSize: 30,
              fontWeight: FontWeight.w500,
              fontFamily: 'DBHeavent',
              color: Color.fromRGBO(16, 96, 196, 1),
            ),
          ),
        ),
        color: Colors.white,
        onPressed: () {},
      ),
    );
  }

  Widget _registerButton() {
    return GestureDetector(
      onTap: () {
        setState(() {
          showDialog(
              useRootNavigator: false,
              context: context,
              builder: (BuildContext context) {
                return Dialog(
                  shape: RoundedRectangleBorder(
                      borderRadius:
                          BorderRadius.circular(20.0)), //this right here
                  child: Container(
                    height: 330.h,
                    child: Padding(
                      padding: const EdgeInsets.all(12.0),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Image.asset(
                            'assets/images/register_term_icon.png',
                            fit: BoxFit.contain,
                            height: 100.h,
                            width: 100.w,
                          ),
                          Container(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "ยินดีต้อนรับเข้าสู่ระบบ สมัครสมาชิก ของ NBT",
                              style: TextStyle(
                                fontSize: 20,
                                fontWeight: FontWeight.w500,
                                fontFamily: 'DBHeavent',
                                color: Color.fromRGBO(77, 32, 126, 1),
                              ),
                            ),
                          ),
                          Container(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "สิทธิพิเศษเฉพาะสมาชิก เท่านั้น",
                              style: TextStyle(
                                fontSize: 20,
                                fontWeight: FontWeight.w500,
                                fontFamily: 'DBHeavent',
                                color: Color.fromRGBO(77, 32, 126, 1),
                              ),
                            ),
                          ),
                          SizedBox(
                            height: 10.h,
                          ),
                          Text(
                            "1. สามารถดูประวัติรับชมส่วนตัวได้\n2. สามารถบันทึกลิงก์รายการโปรดได้\n3. สามารถ Comment ขณะรับชมรายการต่างๆ ได้\n4. สิทธิร่วมรับของรางวัลในโอกาสจัดกิจกรรมพิเศษต่างๆ",
                            style: TextStyle(
                              fontSize: 20,
                              fontWeight: FontWeight.w500,
                              fontFamily: 'DBHeavent',
                              // decoration: TextDecoration.underline,
                              color: Colors.black87,
                            ),
                          ),
                          Padding(
                            padding:
                                EdgeInsets.only(left: 30, right: 30, top: 20),
                            child: RaisedButton(
                              shape: new RoundedRectangleBorder(
                                  borderRadius:
                                      new BorderRadius.circular(30.0)),
                              child: Container(
                                alignment: Alignment.center,
                                height: 35.h,
                                width: double.infinity,
                                child: Text(
                                  "ตกลง",
                                  style: TextStyle(
                                    fontSize: 20,
                                    fontWeight: FontWeight.w500,
                                    fontFamily: 'DBHeavent',
                                    color: Colors.white,
                                  ),
                                ),
                              ),
                              color: Color.fromRGBO(77, 32, 126, 1),
                              onPressed: () async {
                                // Navigator.pop(context);
                                // Navigator.of(context).pop();
                                // Navigator.pop(context, true);
                                // Navigator.of(context, rootNavigator: true)
                                //     .pop();

                                Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                        builder: (context) => TermPage()));
                              },
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                );
              });
        });
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            "คุณมีบัญชีหรือยัง ?",
            style: TextStyle(
                fontSize: 20,
                fontWeight: FontWeight.w500,
                fontFamily: 'DBHeavent',
                color: Colors.grey),
          ),
          Text(
            " สมัครสมาชิก",
            style: TextStyle(
              fontSize: 20,
              fontWeight: FontWeight.w500,
              fontFamily: 'DBHeavent',
              decoration: TextDecoration.underline,
              color: Color.fromRGBO(77, 32, 126, 1),
            ),
          ),
        ],
      ),
    );
  }
}
