import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class FavouriteListPage extends StatefulWidget {
  const FavouriteListPage({Key? key}) : super(key: key);

  @override
  State<FavouriteListPage> createState() => _FavouriteListPageState();
}

class _FavouriteListPageState extends State<FavouriteListPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        home: Scaffold(
            appBar: AppBar(
              elevation: 0.55,
              shadowColor: Color.fromRGBO(77, 32, 126, 1),
              bottomOpacity: 0,
              backgroundColor: Color.fromRGBO(77, 32, 126, 1),
              toolbarHeight: 80.h,
              title: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Container(
                      margin: EdgeInsets.only(top: 10),
                      child: GestureDetector(
                          onTap: () {
                            Navigator.pop(context);
                          },
                          child: Icon(Icons.arrow_back_ios))),
                  SizedBox(
                    width: 110,
                  ),
                  Container(
                    margin: EdgeInsets.only(top: 10),
                    child: Text(
                      'รายการโปรด',
                      style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 30,
                          color: Colors.white),
                    ),
                  )
                ],
              ),
            ),
            body: Container(
                width: MediaQuery.of(context).size.width,
                height: MediaQuery.of(context).size.height,
                child:
                    Stack(alignment: AlignmentDirectional.topStart, children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  )
                ]))));
  }
}
