import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_logo.dart';
import 'package:nbt_app/components/appbar_title.dart';
import 'package:nbt_app/screen/notification/notification_page.dart';

import '../home/home_page.dart';

class NewsPage extends StatefulWidget {
  const NewsPage({Key? key}) : super(key: key);

  @override
  State<NewsPage> createState() => _NewsPageState();
}

List<CardTitle> cardTitles2 = [
  CardTitle(title: '#โควิท'),
  CardTitle(title: '#การเมือง'),
  CardTitle(title: '#เทคโนโลยี'),
  CardTitle(title: '#ธรรมชาติ'),
  CardTitle(title: '#ฟุตบอล'),
  CardTitle(title: '#คุยถึงแก่น'),
  CardTitle(title: '#สภาพอากาศ'),
];

class _NewsPageState extends State<NewsPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        elevation: 0,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80,
        title: const Text('ข่าว',
              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
        ),
        centerTitle: true,
      ),
      body: SingleChildScrollView(
        child: Column(children: [
          Stack(alignment: Alignment.topCenter, children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60,
            ),
            Expanded(
              child: SingleChildScrollView(
                child: Padding(
                  padding: const EdgeInsets.only(left: 10, right: 10),
                  child: Container(
                    width: MediaQuery.of(context).size.width,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(25),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 2,
                              blurRadius: 7,
                              offset: Offset(0, 3))
                        ]),
                    child: Column(
                      children: [
                        Padding(
                          padding: const EdgeInsets.only(left: 20.0, top: 20.0),
                          child: Container(
                            width: MediaQuery.of(context).size.width,
                            height: 35,
                            child: ListView.separated(
                                padding: EdgeInsets.only(top: 6),
                                scrollDirection: Axis.horizontal,
                                itemCount: cardTitles2.length,
                                separatorBuilder: (context, position) =>
                                    SizedBox(
                                      width: 5,
                                    ),
                                itemBuilder: (context, index) {
                                  return buildCardTitle(
                                      item: cardTitles2[index]);
                                }),
                          ),
                        ),
                        SizedBox(
                          height: 20,
                        ),
                        Container(
                          margin: EdgeInsets.only(left: 20.0, right: 20.0),
                          child: Column(
                            children: [
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวเด็ดประเทศไทย',
                                    style: TextStyle(
                                        fontSize: 38, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text(
                                      'ดูทั้งหมด',
                                      style: TextStyle(
                                          fontSize: 22,
                                          color: Color.fromRGBO(77, 32, 126, 1),
                                          fontFamily: 'DBHeavent'),
                                    ),
                                  ),
                                ],
                              ),
                              SizedBox(
                                height: 20,
                              ),
                              Container(
                                  height: 220,
                                  width: MediaQuery.of(context).size.width,
                                  child: ClipRRect(
                                      borderRadius: BorderRadius.circular(10),
                                      child: Image.network(
                                        'https://images.unsplash.com/photo-1580519542036-c47de6196ba5?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NXx8bW9uZXl8ZW58MHx8MHx8&auto=format&fit=crop&w=600&q=60',
                                        fit: BoxFit.cover,
                                      ))),
                              SizedBox(
                                height: 10,
                              ),
                              Row(
                                children: [
                                  Text(
                                    '20/02/21',
                                    style: TextStyle(
                                        color: Colors.grey.shade500,
                                        fontSize: 15),
                                  ),
                                  SizedBox(
                                    width: 5,
                                  ),
                                  Icon(
                                    Icons.remove_red_eye,
                                    size: 13,
                                    color: Colors.grey.shade500,
                                  ),
                                  SizedBox(
                                    width: 5,
                                  ),
                                  Text(
                                    '1000',
                                    style: TextStyle(
                                        color: Colors.grey.shade500,
                                        fontSize: 15),
                                  ),
                                ],
                              ),
                              Text(
                                'ดีกรีแชมป์เจลีก! “ชนาธิป” ได้ล่ามคนใหม่ “นริศ” อดีตคู่หู “ธีราทร”',
                                style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 20),
                              ),
                              underline(20, 20),
                              Container(
                                child: ListView.builder(
                                    padding: EdgeInsets.only(top: 5),
                                    scrollDirection: Axis.vertical,
                                    shrinkWrap: true,
                                    itemCount: cardItems.length,
                                    itemBuilder: (context, index) {
                                      return buildRoundedCard(
                                          item: cardItems[index]);
                                    }),
                              ),
                              underline(20, 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวล่าสุด',
                                    style: TextStyle(
                                        fontSize: 26, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text('ดูทั้งหมด',
                                        style: TextStyle(
                                            fontSize: 22,
                                            color:
                                                Color.fromRGBO(77, 32, 126, 1),
                                            fontFamily: 'DBHeavent')),
                                  ),
                                ],
                              ),
                              Container(
                                height: 200,
                                child: ListView.separated(
                                    padding: EdgeInsets.only(top: 6),
                                    scrollDirection: Axis.horizontal,
                                    itemCount: 2,
                                    separatorBuilder: (context, position) =>
                                        SizedBox(
                                          width: 10,
                                        ),
                                    itemBuilder: (context, index) {
                                      return buildCardImage(
                                          item: cardItems[index]);
                                    }),
                              ),
                              underline(20, 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวเช้า',
                                    style: TextStyle(
                                        fontSize: 26, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text('ดูทั้งหมด',
                                        style: TextStyle(
                                            fontSize: 22,
                                            color:
                                                Color.fromRGBO(77, 32, 126, 1),
                                            fontFamily: 'DBHeavent')),
                                  ),
                                ],
                              ),
                              Container(
                                height: 200,
                                child: ListView.separated(
                                    padding: EdgeInsets.only(top: 6),
                                    scrollDirection: Axis.horizontal,
                                    itemCount: 2,
                                    separatorBuilder: (context, position) =>
                                        SizedBox(
                                          width: 10,
                                        ),
                                    itemBuilder: (context, index) {
                                      return buildCardImage(
                                          item: cardItems[index]);
                                    }),
                              ),
                              underline(20, 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวเที่ยง',
                                    style: TextStyle(
                                        fontSize: 26, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text('ดูทั้งหมด',
                                        style: TextStyle(
                                            fontSize: 22,
                                            color:
                                                Color.fromRGBO(77, 32, 126, 1),
                                            fontFamily: 'DBHeavent')),
                                  ),
                                ],
                              ),
                              Container(
                                height: 200,
                                child: ListView.separated(
                                    padding: EdgeInsets.only(top: 6),
                                    scrollDirection: Axis.horizontal,
                                    itemCount: 2,
                                    separatorBuilder: (context, position) =>
                                        SizedBox(
                                          width: 10,
                                        ),
                                    itemBuilder: (context, index) {
                                      return buildCardImage(
                                          item: cardItems[index]);
                                    }),
                              ),
                              underline(20, 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวเย็น',
                                    style: TextStyle(
                                        fontSize: 26, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text('ดูทั้งหมด',
                                        style: TextStyle(
                                            fontSize: 22,
                                            color:
                                                Color.fromRGBO(77, 32, 126, 1),
                                            fontFamily: 'DBHeavent')),
                                  ),
                                ],
                              ),
                              Container(
                                height: 200,
                                child: ListView.separated(
                                    padding: EdgeInsets.only(top: 6),
                                    scrollDirection: Axis.horizontal,
                                    itemCount: 2,
                                    separatorBuilder: (context, position) =>
                                        SizedBox(
                                          width: 10,
                                        ),
                                    itemBuilder: (context, index) {
                                      return buildCardImage(
                                          item: cardItems[index]);
                                    }),
                              ),
                              underline(20, 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'ข่าวประชาสัมพันธ์',
                                    style: TextStyle(
                                        fontSize: 26, fontFamily: 'DBHeavent'),
                                  ),
                                  Expanded(flex: 1, child: SizedBox()),
                                  GestureDetector(
                                    onTap: () {},
                                    child: Text('ดูทั้งหมด',
                                        style: TextStyle(
                                            fontSize: 22,
                                            color:
                                                Color.fromRGBO(77, 32, 126, 1),
                                            fontFamily: 'DBHeavent')),
                                  ),
                                ],
                              ),
                              Container(
                                height: 200,
                                child: ListView.separated(
                                    padding: EdgeInsets.only(top: 6),
                                    scrollDirection: Axis.horizontal,
                                    itemCount: 2,
                                    separatorBuilder: (context, position) =>
                                        SizedBox(
                                          width: 10,
                                        ),
                                    itemBuilder: (context, index) {
                                      return buildCardImage(
                                          item: cardItems[index]);
                                    }),
                              ),
                              SizedBox(
                                height: 20,
                              )
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ),
          ]),
        ]),
      ),
    );
  }
}
