import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/screen/login/login_page.dart';

class ForgotPasswordPage extends StatefulWidget {
  const ForgotPasswordPage({Key? key}) : super(key: key);

  @override
  _ForgotPasswordPageState createState() => _ForgotPasswordPageState();
}

class _ForgotPasswordPageState extends State<ForgotPasswordPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: AppBar(
        elevation: 0.55,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            // Container(
            //   margin: EdgeInsets.only(top: 10),
            //   child: GestureDetector(
            //     onTap: () {
            //       setState(() {
            //         Navigator.pushReplacement(context,
            //             MaterialPageRoute(builder: (context) => AppBarLogo()));
            //         // Navigator.pop(context);
            //       });
            //     },
            //     child: Icon(Icons.arrow_back_ios),
            //   ),
            // ),
            // Spacer(),
            SizedBox(
              width: 90,
            ),
            Container(
              margin: EdgeInsets.only(top: 10),
              child: Text(
                'ลืมรหัสผ่าน',
                style: TextStyle(
                    fontSize: 30,
                    letterSpacing: 1,
                    fontWeight: FontWeight.w700,
                    // color: Color.fromRGBO(77, 32, 126, 1),
                    color: Colors.white,
                    fontFamily: 'DBHeavent'),
              ),
            ),
            Spacer(),
          ],
        ),
      ),
      body: Stack(
        children: [
          Container(
            color: Color.fromRGBO(77, 32, 126, 1),
            height: 50.h,
          ),
          Container(
            margin: EdgeInsets.only(left: 15.h, right: 15.h),
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              border: Border.all(
                color: Colors.white,
                style: BorderStyle.solid,
                width: 1.0,
              ),
              color: Colors.white,
              borderRadius: BorderRadius.circular(10.0),
            ),
            child: Column(
              children: [
                Container(
                  padding: EdgeInsets.only(left: 20, top: 30),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "Email",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                      color: Color.fromRGBO(77, 32, 126, 1),
                      fontFamily: 'DBHeavent',
                      fontSize: 25,
                      fontWeight: FontWeight.w500,
                    ),
                  ),
                ),
                Container(
                  height: 40.h,
                  padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                  child: TextField(
                    decoration: InputDecoration(
                        border: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(30.0),
                        ),
                        filled: true,
                        contentPadding:
                            EdgeInsets.only(left: 14.0, bottom: 0.0, top: 8.0),
                        focusedBorder: OutlineInputBorder(
                          borderSide: BorderSide(color: Colors.grey),
                          borderRadius: BorderRadius.circular(25.7),
                        ),
                        enabledBorder: OutlineInputBorder(
                          borderSide: BorderSide(color: Colors.grey),
                          borderRadius: BorderRadius.circular(25.7),
                        ),
                        hintStyle: TextStyle(
                          color: Colors.grey,
                          fontFamily: 'DBHeavent',
                          fontSize: 25,
                          fontWeight: FontWeight.w500,
                        ),
                        hintText: "  Email",
                        fillColor: Colors.white),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "วัน / เดือน / ปี",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                      color: Color.fromRGBO(77, 32, 126, 1),
                      fontFamily: 'DBHeavent',
                      fontSize: 25,
                      fontWeight: FontWeight.w500,
                    ),
                  ),
                ),
                Container(
                  height: 40.h,
                  padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                  child: TextField(
                    decoration: InputDecoration(
                        border: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(30.0),
                        ),
                        suffixIcon: Icon(
                          Icons.calendar_today,
                          color: Colors.grey,
                        ),
                        filled: true,
                        contentPadding:
                            EdgeInsets.only(left: 14.0, bottom: 0.0, top: 8.0),
                        focusedBorder: OutlineInputBorder(
                          borderSide: BorderSide(color: Colors.grey),
                          borderRadius: BorderRadius.circular(25.7),
                        ),
                        enabledBorder: OutlineInputBorder(
                          borderSide: BorderSide(color: Colors.grey),
                          borderRadius: BorderRadius.circular(25.7),
                        ),
                        hintStyle: TextStyle(
                          color: Colors.grey,
                          fontFamily: 'DBHeavent',
                          fontSize: 25,
                          fontWeight: FontWeight.w500,
                        ),
                        hintText: "  วว/ดด/ปป",
                        fillColor: Colors.white),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(left: 20, top: 10),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "* กรุณากรอก Email และวันเดือนปีเกิดของท่าน เพื่อยืนยันตัวตน",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                      color: Colors.red,
                      fontFamily: 'DBHeavent',
                      fontSize: 18,
                      fontWeight: FontWeight.w500,
                    ),
                  ),
                ),
                _submitButton(),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget _submitButton() {
    return Padding(
      padding: EdgeInsets.only(left: 20, right: 20, top: 50, bottom: 50),
      child: RaisedButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(30.0)),
        child: Container(
          alignment: Alignment.center,
          height: 40.h,
          width: double.infinity,
          child: Text(
            "ยืนยัน",
            style: TextStyle(
              fontSize: 30,
              fontWeight: FontWeight.w500,
              fontFamily: 'DBHeavent',
              color: Colors.white,
            ),
          ),
        ),
        color: Color.fromRGBO(77, 32, 126, 1),
        onPressed: () {
          setState(() {
            showDialog(
                useRootNavigator: false,
                context: context,
                builder: (BuildContext context) {
                  return Dialog(
                    shape: RoundedRectangleBorder(
                        borderRadius:
                            BorderRadius.circular(20.0)), //this right here
                    child: Container(
                      height: 250.h,
                      child: Padding(
                        padding: const EdgeInsets.all(12.0),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            SizedBox(
                              height: 20,
                            ),
                            Image.asset(
                              'assets/images/ic_success.png',
                              fit: BoxFit.contain,
                              height: 60.h,
                              width: 60.w,
                            ),
                            SizedBox(
                              height: 20,
                            ),
                            Container(
                              alignment: Alignment.center,
                              child: Text(
                                "ระบบได้ส่งรหัสผ่านใหม่\nไปยังอีเมลเรียบร้อยแล้ว",
                                style: TextStyle(
                                    fontSize: 30,
                                    fontWeight: FontWeight.w500,
                                    fontFamily: 'DBHeavent',
                                    color: Colors.black
                                    // color: Color.fromRGBO(77, 32, 126, 1),
                                    ),
                              ),
                            ),
                            SizedBox(
                              height: 10.h,
                            ),
                            Padding(
                              padding:
                                  EdgeInsets.only(left: 30, right: 30, top: 20),
                              child: RaisedButton(
                                shape: new RoundedRectangleBorder(
                                    borderRadius:
                                        new BorderRadius.circular(30.0)),
                                child: Container(
                                  alignment: Alignment.center,
                                  height: 35.h,
                                  width: double.infinity,
                                  child: Text(
                                    "ตกลง",
                                    style: TextStyle(
                                      fontSize: 25,
                                      fontWeight: FontWeight.w500,
                                      fontFamily: 'DBHeavent',
                                      color: Colors.white,
                                    ),
                                  ),
                                ),
                                color: Color.fromRGBO(77, 32, 126, 1),
                                onPressed: () async {
                                  // Navigator.pop(context);
                                  // Navigator.of(context).pop();
                                  // Navigator.pop(context, true);
                                  // Navigator.of(context, rootNavigator: true)
                                  //     .pop();

                                  Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                          builder: (context) => LoginPage()));
                                },
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                });
          });
        },
        // onPressed: () {
        //   Navigator.push(context,
        //       MaterialPageRoute(builder: (context) => RegisterCompletePage()));
        // },
      ),
    );
  }
}
