import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_slider_drawer/flutter_slider_drawer.dart';
import 'package:nbt_app/screen/catch%20up/catchup_page.dart';
import 'package:nbt_app/screen/login/login_page.dart';
import 'package:nbt_app/screen/news/news_page.dart';
import 'package:nbt_app/screen/notification/FavouriteList_Page.dart';

class NBTDrawer extends StatefulWidget {
  const NBTDrawer({ Key? key }) : super(key: key);

  @override
  State<NBTDrawer> createState() => _NBTDrawerState();
}

class _NBTDrawerState extends State<NBTDrawer> {

  @override
  Widget build(BuildContext context) {
    return Drawer(
      backgroundColor: Color.fromRGBO(77, 32, 126, 1),
      child: SingleChildScrollView(
        child: notMember(),
      ),
    );
  }

  member() {
    return Column(
      // padding: EdgeInsets.only(left: 20.0, right: 20, top: 70),
      children: [
        Padding(
          padding: const EdgeInsets.only(left: 20.0, right: 20, top: 70),
          child: ClipRRect(
            borderRadius: BorderRadius.circular(100),
            child: Image.network(
              'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRVulAFwunkwFe7MIclxh0-RBQeKtKY5rGiD4Q88wo2_c6TBDwRFiwHB1jVMetePElX9gA&usqp=CAU',
              fit: BoxFit.cover,
              width: 120.w,
              height: 110.h,
            ),
          ),
        ),
        Padding(
          padding: EdgeInsets.only(left: 70.0, right: 0, top: 0),
          child: ListTile(
            title: const Text(
              'วริศรา มีความสุข',
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            onTap: () {
              Navigator.pop(context);
            },
          ),
        ),
        Container(
          height: 40.0.h,
          width: 150.w,
          child: GestureDetector(
            onTap: () {},
            child: Container(
              decoration: BoxDecoration(
                border: Border.all(
                  color: Colors.white,
                  style: BorderStyle.solid,
                  width: 1.0,
                ),
                color: Colors.transparent,
                borderRadius: BorderRadius.circular(30.0),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Center(
                    child: Text(
                      "แก้ไขโปรไฟล์",
                      style: TextStyle(
                        color: Colors.white,
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                        letterSpacing: 1,
                      ),
                    ),
                  )
                ],
              ),
            ),
          ),
        ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
        SizedBox(
          height: 20.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ข่าว",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "รายการ",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ดูย้อนหลัง",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ผังรายการ",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "Catch up",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ประวัติการรับชม",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        GestureDetector(
          onTap: () {
            setState(() {
              Navigator.push(context,
                  MaterialPageRoute(builder: (context) => FavouriteListPage()));
            });
          },
          child: Row(
            children: [
              SizedBox(
                width: 20.w,
              ),
              Text(
                "รายการโปรด",
                style: TextStyle(
                  color: Colors.white,
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                  letterSpacing: 1,
                ),
              ),
              Spacer(),
              Icon(
                Icons.arrow_forward_ios_rounded,
                color: Colors.white,
              ),
              SizedBox(
                width: 20.w,
              ),
            ],
          ),
        ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
        SizedBox(
          height: 20.h,
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ข้อมูลส่วนตัว",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "การตั้งค่า",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "แจ้งปัญหาการใช้งาน",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
        SizedBox(
          height: 20.h,
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ออกจากระบบ",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
          ],
        ),
        SizedBox(
          height: 30.h,
        ),
      ],
    );
  }

  notMember() {
    return Column(
      children: [
        SizedBox(
          height: 40.h,
        ),
        Image.asset(
          'assets/images/title_logo.png',
          fit: BoxFit.contain,
          height: 100,
          width: 100,
        ),
        SizedBox(
          height: 20.h,
        ),
        Container(
          height: 35.0.h,
          width: 120.w,
          child: GestureDetector(
            onTap: () {
              Navigator.push(context,
                  MaterialPageRoute(builder: (context) => LoginPage()));
            },
            child: Container(
              decoration: BoxDecoration(
                border: Border.all(
                  color: Colors.white,
                  style: BorderStyle.solid,
                  width: 1.0,
                ),
                color: Colors.transparent,
                borderRadius: BorderRadius.circular(30.0),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  Center(
                    child: Text(
                      "เข้าสู่ระบบ",
                      style: TextStyle(
                        color: Colors.white,
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                        letterSpacing: 1,
                      ),
                    ),
                  )
                ],
              ),
            ),
          ),
        ),
        SizedBox(
          height: 10.h,
        ),
        // GestureDetector(
        //   onTap: () {
        //     setState(() {
        //       Navigator.pushReplacement(context,
        //           MaterialPageRoute(builder: (context) => RegisterPage()));
        //     });
        //   },
        //   child: Text(
        //     "สมัครสมาชิก",
        //     style: TextStyle(
        //       color: Colors.white,
        //       fontFamily: 'DBHeavent',
        //       fontSize: 25,
        //       fontWeight: FontWeight.w500,
        //       letterSpacing: 1,
        //     ),
        //   ),
        // ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
        SizedBox(
          height: 20.h,
        ),
        GestureDetector(
          onTap: () {
            setState(() {
              Navigator.push(
                  context, MaterialPageRoute(builder: (context) => NewsPage()));
            });
          },
          child: Row(
            children: [
              SizedBox(
                width: 20.w,
              ),
              Text(
                "ข่าว",
                style: TextStyle(
                  color: Colors.white,
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                  letterSpacing: 1,
                ),
              ),
              Spacer(),
              Icon(
                Icons.arrow_forward_ios_rounded,
                color: Colors.white,
              ),
              SizedBox(
                width: 20.w,
              ),
            ],
          ),
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "รายการ",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ดูย้อนหลัง",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "ผังรายการ",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 10.h,
        ),
        GestureDetector(
          onTap: () {
            Navigator.push(context,
                MaterialPageRoute(builder: (context) => CatchupPage()));
          },
          child: Row(
            children: [
              SizedBox(
                width: 20.w,
              ),
              Text(
                "Catch up",
                style: TextStyle(
                  color: Colors.white,
                  fontFamily: 'DBHeavent',
                  fontSize: 25,
                  fontWeight: FontWeight.w500,
                  letterSpacing: 1,
                ),
              ),
              Spacer(),
              Icon(
                Icons.arrow_forward_ios_rounded,
                color: Colors.white,
              ),
              SizedBox(
                width: 20.w,
              ),
            ],
          ),
        ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
        SizedBox(
          height: 20.h,
        ),
        Row(
          children: [
            SizedBox(
              width: 20.w,
            ),
            Text(
              "แจ้งปัญหาการใช้งาน",
              style: TextStyle(
                color: Colors.white,
                fontFamily: 'DBHeavent',
                fontSize: 25,
                fontWeight: FontWeight.w500,
                letterSpacing: 1,
              ),
            ),
            Spacer(),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Colors.white,
            ),
            SizedBox(
              width: 20.w,
            ),
          ],
        ),
        SizedBox(
          height: 20.h,
        ),
        Divider(
          color: Colors.grey,
          height: 1,
        ),
      ],
    );
  }

}