import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/screen/favorite/favouriteList_Page.dart';

class SchedulePage extends StatefulWidget {
  const SchedulePage({ Key? key }) : super(key: key);

  @override
  State<SchedulePage> createState() => _SchedulePageState();
}

class _SchedulePageState extends State<SchedulePage> with SingleTickerProviderStateMixin {

  final _dayTabs = <Tab>[
   Tab(
     child: Column(
       children: [
         Text('เสาร์',
          style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('1',
          style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('อาทิตย์',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('2',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('จันทร์',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('3',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('อังคาร',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('4',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('พุธ',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('5',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('พฤหัสบดี',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('6',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
   Tab(
     child: Column(
       children: [
         Text('ศุกร์',
         style: TextStyle(fontFamily: 'DBHeavent'),
         ),
         Text('7',
         style: TextStyle(fontFamily: 'DBHeavent'),
         )
       ]),
   ),
  ];

  final _tabPages = <Widget>[
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
    Container(
      child: ListView.builder(
        itemCount: programsList.length,
        itemBuilder: (context, index) {
          return buildPrograms(
            data: programsList[index]
            );
          }
      )
    ),
  ];

  late TabController _tabcontroller;

  @override
  void initState() {
    _tabcontroller = TabController(length: _dayTabs.length, vsync: this);
    super.initState();
  }

  @override
  void dispose() {
    _tabcontroller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        appBar: AppBar(
            elevation: 0,
            shadowColor: Color.fromRGBO(77, 32, 126, 1),
            bottomOpacity: 0,
            backgroundColor: Color.fromRGBO(77, 32, 126, 1),
            toolbarHeight: 80.h,
            title: const Text('ผังรายการ',
              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
            ),
            centerTitle: true,
            leading: GestureDetector(
              onTap: (){
                Navigator.pop(context);
              },
              child: Icon(
                Icons.arrow_back_ios,
                color: Colors.white,
              ),
            ),
          ),
          body: Container(
                width: MediaQuery.of(context).size.width,
                height: MediaQuery.of(context).size.height,
                child: Stack(children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  ),
                  Container(
                    padding: EdgeInsets.only(top: 20, left: 20, right: 20),
                    margin: EdgeInsets.only(left: 15, right: 15),
                    width: 400,
                    decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(10),
                        boxShadow: [
                          BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 3,
                              blurRadius: 6)
                        ]),
                    child: Column(
                      children: [
                        Text('มกราคม 2565',
                              style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 30),
                        ),
                        Container(
                          padding: EdgeInsets.only(
                              left: 5, right: 5, top: 5, bottom: 5),
                          height: 50.h,
                          child: TabBar(
                            isScrollable: true,
                              labelColor: Colors.red,
                              unselectedLabelColor: Color.fromRGBO(77, 32, 126, 1),
                              indicatorColor: Colors.red,
                              indicatorWeight: 2,
                              // indicator: BoxDecoration(
                              //     color: Colors.white,
                              //     borderRadius: BorderRadius.circular(5)),
                              controller: _tabcontroller,
                              tabs: _dayTabs
                              ),
                        ),
                        Container(
                          height: MediaQuery.of(context).size.height/1.5,
                          child:
                              TabBarView(
                              controller: _tabcontroller,
                              children: _tabPages,
                          ),
                        )
                      ],
                    ),
                  )
                ]
                )
                )
        ),
    );
  }
}

Widget buildPrograms({required Programs data}) => Container(
  padding: EdgeInsets.only(top: 5.0,bottom: 5.0),
  child: Column(
    mainAxisAlignment: MainAxisAlignment.start,
    crossAxisAlignment: CrossAxisAlignment.start,
    children: [
      const Divider(),
      Row(
        children: [
          Text(
            data.startTime,
            style: TextStyle(
              color: Color.fromRGBO(161, 159, 163, 1),
              fontSize: 18,
              fontFamily: 'DBHeavent'
            ),
          ),
          Text(
            ' - ',
            style: TextStyle(
              color: Color.fromRGBO(161, 159, 163, 1),
              fontSize: 18,
              fontFamily: 'DBHeavent'
            ),
          ),
          Text(
            data.endTime,
            style: TextStyle(
              color: Color.fromRGBO(161, 159, 163, 1),
              fontSize: 18,
              fontFamily: 'DBHeavent'
            ),
          ),
        ],
      ),
      Text(
        data.programName,
        style: TextStyle(
          color: Color.fromRGBO(161, 159, 163, 1),
          fontSize: 24,
          fontFamily: 'DBHeavent'
        ),
      ),
    ],
  ),
);

class Programs {
  String startTime,endTime,programName;

  Programs(
    {
      required this.startTime,
      required this.endTime,
      required this.programName
    }
  );
}

List<Programs> programsList = [
  Programs(
    startTime: '04:00',
    endTime: '05:00',
    programName: 'ประทีปธรรมนำชีวิต'
  ),
  Programs(
    startTime: '05:00',
    endTime: '06:30',
    programName: 'NBT News ภาคเช้า'
  ),
  Programs(
    startTime: '06:30',
    endTime: '08:30',
    programName: 'คุยถึงแก่น'
  ),
  Programs(
    startTime: '08:30',
    endTime: '09:00',
    programName: 'สถานีศิริราช'
  ),
  Programs(
    startTime: '09:00',
    endTime: '12:00',
    programName: 'NBT รวมใจสู้ภัยโควิด-19'
  ),
  Programs(
    startTime: '12:00',
    endTime: '14:00',
    programName: 'NBT News ภาคเที่ยง'
  ),
  Programs(
    startTime: '14:30',
    endTime: '14:30',
    programName: 'เกาะกระแสหุ้น'
  ),
];