import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/screen/home/home_page.dart';

class RewindSearchResultPage extends StatefulWidget {
  const RewindSearchResultPage({ Key? key }) : super(key: key);

  @override
  State<RewindSearchResultPage> createState() => _RewindSearchResultPageState();
}

class _RewindSearchResultPageState extends State<RewindSearchResultPage> {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        appBar: AppBar(
            elevation: 0,
            shadowColor: Color.fromRGBO(77, 32, 126, 1),
            bottomOpacity: 0,
            backgroundColor: Color.fromRGBO(77, 32, 126, 1),
            toolbarHeight: 80.h,
            title: const Text('ดูย้อนหลัง',
              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
            ),
            centerTitle: true,
            leading: GestureDetector(
              onTap: (){
                Navigator.pop(context);
              },
              child: Icon(
                Icons.arrow_back_ios,
                color: Colors.white,
              ),
            ),
          ),
          body: SingleChildScrollView(
            child: Column(
              children: [
                Stack(alignment: Alignment.topCenter,children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  ),
                  Expanded(
                    child: Padding(
                      padding: const EdgeInsets.all(15.0),
                      child: Container(
                        width: MediaQuery.of(context).size.width,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(25),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 2,
                              blurRadius: 7,
                              offset: Offset(0,3)
                            )
                          ]
                        ),
                        child: Column(
                          children: [
                            SizedBox(
                              height: 20.0,
                            ),
                            Padding(
                              padding: const EdgeInsets.only(right: 20.0),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.end,
                                children: [
                                  Padding(
                                    padding: const EdgeInsets.only(right: 10.0),
                                    child: Text('เรียงตาม',
                                      style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                    ),
                                  ),
                                  Container(
                                    padding: EdgeInsets.only(left: 10.0,right: 10.0),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(8.0),
                                      border: Border.all(
                                        color: Color.fromRGBO(77, 32, 126, 1),
                                      ),
                                    ),
                                    child: DropdownButtonHideUnderline(
                                      child: DropdownButton(
                                        icon: Icon(Icons.arrow_drop_down),
                                        items: <String>[
                                          'ยอดนิยม',
                                          'แนะนำ',
                                          'ก-ฮ , A-Z',
                                          'ฮ-ก , Z-A'
                                        ].map<DropdownMenuItem<String>>((String value){
                                          return DropdownMenuItem<String>(
                                            value: value,
                                            child: Text(
                                              value,
                                              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                            ),
                                          );
                                        }).toList(),
                                        onChanged: (value) { 
                                          setState(() {
                                            //_selectedValue = value.toString();
                                          });
                                        },
                                        //value: _selectedValue,
                                        hint: Text(
                                          'ยอดนิยม',
                                          style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            SizedBox(
                              height: 20,
                            ),
                            Container(
                              padding: EdgeInsets.only(left: 20.0,right: 20.0),
                              child: GridView.count(
                                crossAxisCount: 2,
                                shrinkWrap: true,
                                mainAxisSpacing: 10.0,
                                crossAxisSpacing: 8.0,
                                children: List.generate(cardItems.length, (index) {
                                  return buildCardImage(item: cardItems[index]);
                                }
                                )
                              ),
                            ),
                            SizedBox(
                              height: 20,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ],
                ),
              ]
              ),
          ),
      ),
    );
  }
}