import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:intl/intl.dart';
import 'package:nbt_app/screen/rewind/rewind_search_result_page.dart';


class RewindSearchPage extends StatefulWidget {
  const RewindSearchPage({ Key? key }) : super(key: key);

  @override
  State<RewindSearchPage> createState() => _RewindSearchPageState();
}

class _RewindSearchPageState extends State<RewindSearchPage> {

DateTime? _dateTime;
DateFormat formatDate = DateFormat('dd-MM-yyyy');

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        appBar: AppBar(
            elevation: 0,
            shadowColor: Color.fromRGBO(77, 32, 126, 1),
            bottomOpacity: 0,
            backgroundColor: Color.fromRGBO(77, 32, 126, 1),
            toolbarHeight: 80.h,
            title: const Text('ดูย้อนหลัง',
              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
            ),
            centerTitle: true,
            leading: GestureDetector(
              onTap: (){
                Navigator.pop(context);
              },
              child: Icon(
                Icons.arrow_back_ios,
                color: Colors.white,
              ),
            ),
          ),
          body: SingleChildScrollView(
            child: Column(
              children: [
                Stack(alignment: Alignment.topCenter,children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  ),
                  Expanded(
                    child: Padding(
                      padding: const EdgeInsets.all(15.0),
                      child: Container(
                        width: MediaQuery.of(context).size.width,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(25),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 2,
                              blurRadius: 7,
                              offset: Offset(0,3)
                            )
                          ]
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.only(left: 20.0,top: 20.0),
                              alignment: Alignment.centerLeft,
                              child: Text('ใส่คำค้นหา',
                                style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1),),
                              ),
                            ),
                            Container(
                              padding: const EdgeInsets.only(left:20.0,right: 20.0,top: 5.0,bottom: 20.0),
                              child: SizedBox(
                                height: 50,
                                child: TextFormField(
                                  textAlign: TextAlign.start,
                                  decoration: InputDecoration(
                                    filled: true,
                                    fillColor: Colors.white,
                                    suffixIcon: IconButton(
                                      icon: Icon(Icons.search,
                                      color: Color.fromRGBO(77, 32, 126, 1),
                                      ),
                                      onPressed: (){
                                        setState(() {
                                        });
                                      },
                                    ),
                                    contentPadding: const EdgeInsets.only(
                                      left: 20.0
                                    ),
                                    focusedBorder: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)
                                    ),
                                    enabledBorder: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)
                                    ),
                                    border: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)),
                                    hintText: 'ใส่คำค้นหา'
                                    //hintStyle: const TextStyle(fontFamily: 'DBHeavent'),
                                  ),
                                ),
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.only(left: 20.0,bottom: 10.0,right: 20.0),
                              alignment: Alignment.centerLeft,
                              child: Row(
                                children: [
                                  Text('เลือกหมวดหมู่',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1),),
                                  ),
                                  Expanded(child: SizedBox(width: MediaQuery.of(context).size.width/4)),
                                  Text('เลือกตามปฏิทิน',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1),),
                                  ),
                                  Expanded(child: SizedBox(width: MediaQuery.of(context).size.width/4)),
                                ],
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.only(left: 20.0,bottom: 10.0,right: 20.0),
                              alignment: Alignment.centerLeft,
                              child: Row(
                                children: [
                                  Container(
                                    width: 150,
                                    padding: EdgeInsets.only(left: 10.0,right: 10.0),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      border: Border.all(
                                        color: Colors.grey.withOpacity(0.3)
                                      ),
                                    ),
                                    child: DropdownButtonHideUnderline(
                                      child: DropdownButton(
                                        icon: Icon(Icons.arrow_drop_down),
                                        items: <String>[
                                          'ก',
                                          'ข',
                                          'ค',
                                          'ง'
                                        ].map<DropdownMenuItem<String>>((String value){
                                          return DropdownMenuItem<String>(
                                            value: value,
                                            child: Text(
                                              value,
                                              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                            ),
                                          );
                                        }).toList(),
                                          onChanged: (value) { 
                                            setState(() {
                                              //_selectedValue = value.toString();
                                            });
                                          },
                                          //value: _selectedValue,
                                          hint: Text(
                                            'เลือกหมวดหมู่',
                                            style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                          ),
                                        ),
                                      ),
                                    ),
                                    Expanded(child: SizedBox()),
                                    Container(
                                      width: 160,
                                      decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      border: Border.all(
                                        color: Colors.grey.withOpacity(0.3)
                                        ),
                                      ),
                                      child: TextButton(
                                        onPressed: (){
                                          showDatePicker(
                                            context: context,
                                            initialDate: new DateTime.now(),
                                            firstDate: new DateTime(DateTime.now().year -10),
                                            lastDate: new DateTime(DateTime.now().year +10)
                                            ).then((date){
                                              setState(() {
                                                _dateTime = date;
                                              });
                                            }
                                            );
                                        },
                                        child: Row(
                                          children: [
                                            Padding(
                                              padding: const EdgeInsets.only(left: 10),
                                              child: Text(_dateTime == null ? 'เลือกตามปฏิทิน': formatDate.format(_dateTime!).toString(),
                                                style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Colors.black.withOpacity(0.6)),
                                              ),
                                            ),
                                            Expanded(child: SizedBox()),
                                            Icon(
                                              Icons.calendar_today_outlined,
                                              size: 20.0,
                                              color: Color.fromRGBO(77, 32, 126, 1),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    Expanded(child: SizedBox()),
                                ],
                              ),
                            ),
                            SizedBox(
                              height: 20.0,
                            ),
                            Expanded(
                              flex: 0,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                  left: 20.0,
                                  right: 20.0,
                                ),
                                child: Container(
                                  height: 50,
                                  width: MediaQuery.of(context).size.width,
                                  child: TextButton(
                                    onPressed: (() {
                                      Navigator.push(context, MaterialPageRoute(builder: (context) => const RewindSearchResultPage()));
                                    }),
                                    style: TextButton.styleFrom(
                                        primary: Colors.white,
                                      ),
                                    child: const Text('ค้นหา',
                                    style: TextStyle(fontSize: 16),
                                    ),
                                  ),
                                  decoration: BoxDecoration(
                                    gradient: const LinearGradient(
                                      begin: Alignment.topCenter,
                                      end: Alignment.bottomCenter,
                                      colors: [Color(0xFF7A4F9F),Color(0xFF4D207E)]
                                      ),
                                    borderRadius: BorderRadius.circular(50)
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(
                              height: MediaQuery.of(context).size.height/2.5,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ],
                ),
              ]
              ),
          ),
        ),
    );
  }
}