import 'package:flutter/material.dart';
import 'package:nbt_app/components/drawer.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/home/home_search.dart';
import 'package:nbt_app/screen/news/news_page.dart';
import 'package:nbt_app/screen/notification/notification_page.dart';

class ProgramsPage extends StatefulWidget {
  const ProgramsPage({ Key? key }) : super(key: key);

  @override
  State<ProgramsPage> createState() => _ProgramsPageState();
}

List<CardTitle> cardTitles3 = [
  CardTitle(title: 'สารคดี ท่องเที่ยว ภูมิภาค'),
  CardTitle(title: 'ศาสนา ศิลปะ วัฒนธรรม'),
  CardTitle(title: 'เกษตร-เศรษฐกิจ'),
  CardTitle(title: 'เด็ก ผู้สูงอายุ ผู้พิการ'),
  CardTitle(title: 'อาเซียน'),
  CardTitle(title: 'อื่นๆ'),
];

class _ProgramsPageState extends State<ProgramsPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        elevation: 0,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80,
        title: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(child: SizedBox()),
                SizedBox(
                  width: 10.0,
                ),
                const Text('รายการ',
                  style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
                ),
                Expanded(child: SizedBox()),
                GestureDetector(
                  onTap: () {
                    setState(() {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => NotificationPage()));
                    });
                  },
                  child: Icon(Icons.notifications_none),
                ),
                SizedBox(width: 10.0),
                GestureDetector(
                    onTap: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const HomeSearchPage()));
                    },
                    child: Icon(Icons.search)),
              ],
            ),
        centerTitle: true,
      ),
      drawer: NBTDrawer(),
      body: SingleChildScrollView(
        child: Column(children: [
          Stack(alignment: Alignment.topCenter, children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60,
            ),
            Expanded(
              child: SingleChildScrollView(
                child: Padding(
                  padding: const EdgeInsets.only(left: 10, right: 10),
                  child: Container(
                    width: MediaQuery.of(context).size.width,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(25),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 2,
                              blurRadius: 7,
                              offset: Offset(0, 3))
                        ]),
                    child: Column(
                      children: [
                        Padding(
                          padding: const EdgeInsets.only(left: 20.0, top: 20.0),
                          child: Container(
                            width: MediaQuery.of(context).size.width,
                            height: 35,
                            child: ListView.separated(
                                padding: EdgeInsets.only(top: 6),
                                scrollDirection: Axis.horizontal,
                                itemCount: cardTitles3.length,
                                separatorBuilder: (context, position) =>
                                    SizedBox(
                                      width: 5,
                                    ),
                                itemBuilder: (context, index) {
                                  return buildCardTitle(
                                      item: cardTitles3[index]);
                                }),
                          ),
                        ),
                        SizedBox(
                          height: 20,
                        ),
                        Container(
                          margin: EdgeInsets.only(left: 20.0, right: 20.0),
                          child: Column(
                            children: [
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    'รายการทั้งหมดช่อง NBT Digital 2HD',
                                    style: TextStyle(
                                        fontSize: 30, fontFamily: 'DBHeavent'),
                                  ),
                                ],
                              ),
                              Padding(
                              padding: const EdgeInsets.only(top: 20.0,bottom: 20.0),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.end,
                                children: [
                                  Padding(
                                    padding: const EdgeInsets.only(right: 10.0),
                                    child: Text('เรียงตาม',
                                      style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                    ),
                                  ),
                                  Container(
                                    padding: EdgeInsets.only(left: 10.0,right: 10.0),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(8.0),
                                      border: Border.all(
                                        color: Color.fromRGBO(77, 32, 126, 1),
                                      ),
                                    ),
                                    child: DropdownButtonHideUnderline(
                                      child: DropdownButton(
                                        icon: Icon(Icons.arrow_drop_down),
                                        items: <String>[
                                          'ยอดนิยม',
                                          'แนะนำ',
                                          'ก-ฮ , A-Z',
                                          'ฮ-ก , Z-A'
                                        ].map<DropdownMenuItem<String>>((String value){
                                          return DropdownMenuItem<String>(
                                            value: value,
                                            child: Text(
                                              value,
                                              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                            ),
                                          );
                                        }).toList(),
                                          onChanged: (value) { 
                                            setState(() {
                                              //_selectedValue = value.toString();
                                            });
                                          },
                                          //value: _selectedValue,
                                          hint: Text(
                                            'ยอดนิยม',
                                            style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Container(
                              child: GridView.count(
                                  crossAxisCount: 2,
                                  shrinkWrap: true,
                                  mainAxisSpacing: 10.0,
                                  crossAxisSpacing: 8.0,
                                  children: List.generate(cardItems.length, (index) {
                                    return buildCardImage(item: cardItems[index]);
                                  }
                                  )
                                ),
                              ),
                              SizedBox(
                                height: 40,
                              )
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ),
          ]),
        ]),
      ),
    );
  }
}