import 'package:flutter/material.dart';
import 'package:nbt_app/components/drawer.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/home/home_search.dart';
import 'package:nbt_app/screen/notification/notification_page.dart';

class TvOnlinePage extends StatefulWidget {
  const TvOnlinePage({ Key? key }) : super(key: key);

  @override
  State<TvOnlinePage> createState() => _TvOnlinePageState();
}

class _TvOnlinePageState extends State<TvOnlinePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        elevation: 0,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80,
        title: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(child: SizedBox()),
                SizedBox(
                  width: 10.0,
                ),
                const Text('ทีวีออนไลน์',
                  style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
                ),
                Expanded(child: SizedBox()),
                GestureDetector(
                  onTap: () {
                    setState(() {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => NotificationPage()));
                    });
                  },
                  child: Icon(Icons.notifications_none),
                ),
                SizedBox(width: 10.0),
                GestureDetector(
                    onTap: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const HomeSearchPage()));
                    },
                    child: Icon(Icons.search)),
              ],
            ),
        centerTitle: true,
      ),
      drawer: NBTDrawer(),
      body: SingleChildScrollView(
        child: Column(
          children: [
          Stack(alignment: Alignment.topCenter, children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60,
            ),
            Expanded(
              child: SingleChildScrollView(
                child: Padding(
                  padding: const EdgeInsets.only(left: 15, right: 15),
                  child: Container(
                    width: MediaQuery.of(context).size.width,
                    decoration: BoxDecoration(
                        //borderRadius: BorderRadius.circular(25),
                        color: Colors.transparent,
                        ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          height: 250,
                          width: MediaQuery.of(context).size.width,
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(15),
                            image: DecorationImage(
                              fit: BoxFit.cover,
                              image: NetworkImage('https://images.unsplash.com/photo-1643288178515-8b4ba815313a?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHwxMHx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60'),
                            ),
                          ),
                        ),
                        SizedBox(
                          height: 20,
                        ),
                        Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              children: [
                                Text('15 ม.ค. 65',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 20),
                                ),
                                SizedBox(
                                  width: 10,
                                ),
                                Icon(
                                    Icons.remove_red_eye,
                                    size: 15,
                                    color: Colors.grey.shade500,
                                ),
                                SizedBox(
                                  width: 5,
                                ),
                                Text('999',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 20),
                                ),
                                Expanded(child: SizedBox()),
                                Text('Share : ',
                                  style: TextStyle(
                                      fontFamily: 'DBHeavent', fontSize: 20,color: Color.fromRGBO(77, 32, 126, 1),),
                                ),
                                SizedBox(
                                  width: 2,
                                ),
                                Icon(
                                    Icons.share,
                                    size: 20,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                ),
                              ],
                            ),
                            Text('ข่าวเช้า NBT',
                              style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 30),
                            ),
                          ],
                        ),
                        underline(20, 20),
                        Row(
                          children: [
                            Text('Comments',
                              style: TextStyle(
                                fontFamily: 'DBHeavent', fontSize: 20,color: Color.fromRGBO(77, 32, 126, 1),),
                            ),
                            Expanded(child: SizedBox()),
                            Icon(
                                    Icons.unfold_more,
                                    size: 20,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                ),
                          ],
                        ),
                        SizedBox(
                          height: 10,
                        ),
                        Row(
                          children: [
                            CircleAvatar(
                              radius: 25, // Image radius
                              backgroundImage: NetworkImage('https://images.unsplash.com/photo-1643288178515-8b4ba815313a?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHwxMHx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60'),
                            ),
                            SizedBox(
                              width: 20,
                            ),
                            Text('Add a comment...',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent', fontSize: 20),
                            ),
                          ],
                        ),
                        underline(20, 20),
                        Row(
                          children: [
                            Text('รายการต่อไป',
                              style: TextStyle(
                                fontFamily: 'DBHeavent', fontSize: 36),
                            ),
                            Expanded(child: SizedBox()),
                            Text('ผังรายการ > ',
                              style: TextStyle(
                                fontFamily: 'DBHeavent', fontSize: 20,color: Color.fromRGBO(77, 32, 126, 1),),
                            ),
                          ],
                        ),
                        Container(
                                child: ListView.builder(
                                    padding: EdgeInsets.only(top: 20,bottom: 100),
                                    scrollDirection: Axis.vertical,
                                    shrinkWrap: true,
                                    itemCount: cardItems.length,
                                    itemBuilder: (context, index) {
                                      return buildRoundedCard(
                                          item: cardItems[index]);
                                    }),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ),
          ]),
        ]),
      ),
    );
  }
}