import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/home/home_search_result.dart';

class HomeSearchPage extends StatefulWidget {
  const HomeSearchPage({ Key? key }) : super(key: key);

  @override
  State<HomeSearchPage> createState() => _HomeSearchPageState();
}

class _HomeSearchPageState extends State<HomeSearchPage> {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        appBar: AppBar(
            elevation: 0,
            shadowColor: Color.fromRGBO(77, 32, 126, 1),
            bottomOpacity: 0,
            backgroundColor: Color.fromRGBO(77, 32, 126, 1),
            toolbarHeight: 80.h,
            title: const Text('ค้นหา',
              style: TextStyle(fontFamily: 'DBHeavent',fontSize: 28),
            ),
            centerTitle: true,
            leading: GestureDetector(
              onTap: (){
                Navigator.pop(context);
              },
              child: Icon(
                Icons.arrow_back_ios,
                color: Colors.white,
              ),
            ),
          ),
          body: SingleChildScrollView(
            child: Column(
              children: [
                Stack(alignment: Alignment.topCenter,children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  ),
                  Expanded(
                    child: Padding(
                      padding: const EdgeInsets.all(15.0),
                      child: Container(
                        width: MediaQuery.of(context).size.width,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(25),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 2,
                              blurRadius: 7,
                              offset: Offset(0,3)
                            )
                          ]
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: const EdgeInsets.all(20.0),
                              child: SizedBox(
                                height: 50,
                                child: TextFormField(
                                  textAlign: TextAlign.start,
                                  decoration: InputDecoration(
                                    filled: true,
                                    fillColor: Colors.white,
                                    suffixIcon: IconButton(
                                      icon: Icon(Icons.search,
                                      color: Color.fromRGBO(77, 32, 126, 1),
                                      ),
                                      onPressed: (){
                                        setState(() {
                                          Navigator.push(context, MaterialPageRoute(builder: (context) => const HomeSearchResult()));
                                        });
                                      },
                                    ),
                                    contentPadding: const EdgeInsets.only(
                                      left: 20.0
                                    ),
                                    focusedBorder: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)
                                    ),
                                    enabledBorder: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)
                                    ),
                                    border: OutlineInputBorder(
                                      borderSide: BorderSide(color: Colors.grey.withOpacity(0.3)),
                                      borderRadius: BorderRadius.circular(50)),
                                    hintText: 'ค้นหา'
                                    //hintStyle: const TextStyle(fontFamily: 'DBHeavent'),
                                  ),
                                ),
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.only(left: 20.0,bottom: 10.0),
                              alignment: Alignment.centerLeft,
                              child: Text('คำค้นหายอดนิยม',
                                style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18),
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.only(left: 20.0,right: 20.0),
                            //   child: Wrap(
                            //     crossAxisAlignment: WrapCrossAlignment.start,
                            //     spacing: 20.0,
                            //     runSpacing: 20.0,
                            //     children: <Widget>[
                            //       Container(
                            //         height: 40,
                            //         padding: EdgeInsets.all(10.0),
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#โควิด-19'),
                            //       ),
                            //       Container(
                            //         height: 40,
                            //         padding: EdgeInsets.all(10.0),
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#ข่าวการเมือง'),
                            //       ),
                            //       Container(
                            //         height: 40,
                            //         padding: EdgeInsets.all(10.0),
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#คุยถึงแก่น'),
                            //       ),
                            //       Container(
                            //         height: 40,
                            //         padding: EdgeInsets.all(10.0),
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#ฟุตบอลโลก'),
                            //       ),
                            //       Container(
                            //         height: 40,
                            //         padding: EdgeInsets.all(10.0),
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#TOBENUMBER1'),
                            //       ),
                            //     ]
                            //   ),
                              child: GridView.count(
                                crossAxisCount: 3,
                                crossAxisSpacing: 20,
                                mainAxisSpacing: 20,
                                childAspectRatio: 3,
                                shrinkWrap: true,
                                children: <Widget>[
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      color: Color.fromRGBO(241, 229, 253, 1),
                                    ),
                                    child: Center(child: Text('#โควิด-19',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1)),
                                    )),
                                  ),
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      color: Color.fromRGBO(241, 229, 253, 1),
                                    ),
                                    child: Center(child: Text('#ข่าวการเมือง',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1)),
                                    )),
                                  ),
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      color: Color.fromRGBO(241, 229, 253, 1),
                                    ),
                                    child: Center(child: Text('#คุยถึงแก่น',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1)),
                                    )),
                                  ),
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      color: Color.fromRGBO(241, 229, 253, 1),
                                    ),
                                    child: Center(child: Text('#ฟุตบอลโลก',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1)),
                                    )),
                                  ),
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(25.0),
                                      color: Color.fromRGBO(241, 229, 253, 1),
                                    ),
                                    child: Center(child: Text('#TOBENUMBER1',
                                    style: TextStyle(fontFamily: 'DBHeavent',fontSize: 18,color: Color.fromRGBO(77, 32, 126, 1)),
                                    )),
                                  ),
                                ]
                              ),
                            ),
                            SizedBox(
                              height: MediaQuery.of(context).size.height-400,
                            ),
                            // GridView.count(
                            //   physics: NeverScrollableScrollPhysics(),
                            //   padding: const EdgeInsets.all(10.0),
                            //   crossAxisCount: 3,
                            //   children: <Widget>[
                            //     Expanded(
                            //       child: Container(
                            //         decoration: BoxDecoration(
                            //           borderRadius: BorderRadius.circular(25.0),
                            //           color: Color.fromRGBO(241, 229, 253, 1),
                            //           ),
                            //         child: Text('#โควิด-19'),
                            //       ),
                            //     ),
                            //     Expanded(
                            //       child: Container(
                            //         decoration: BoxDecoration(borderRadius: BorderRadius.circular(25.0),
                            //         color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#ข่าวการเมือง'),
                            //       ),
                            //     ),
                            //     Expanded(
                            //       child: Container(
                            //         decoration: BoxDecoration(borderRadius: BorderRadius.circular(25.0),
                            //         color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#คุยถึงแก่น'),
                            //       ),
                            //     ),
                            //     Expanded(
                            //       child: Container(
                            //         decoration: BoxDecoration(borderRadius: BorderRadius.circular(25.0),
                            //         color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#ฟุตบอลโลก'),
                            //       ),
                            //     ),
                            //     Expanded(
                            //       child: Container(
                            //         decoration: BoxDecoration(borderRadius: BorderRadius.circular(25.0),
                            //         color: Color.fromRGBO(241, 229, 253, 1),
                            //         ),
                            //         child: Text('#TOBENUMBER1'),
                            //       ),
                            //     ),
                            //   ],
                            // ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ],
                ),
              ]
              ),
          ),
        ),
    );
  }
}