import 'package:country_code_picker/country_code_picker.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:intl/intl.dart';

class EditProfilePage extends StatefulWidget {
  const EditProfilePage({Key? key}) : super(key: key);

  @override
  State<EditProfilePage> createState() => _EditProfilePageState();
}

class _EditProfilePageState extends State<EditProfilePage> {
  List<String> gender = ['ชาย', 'หญิง'];
  String? select;
  DateTime? _dateTime;
  DateFormat format = DateFormat('dd MM yyyy');
  TimeOfDay? time;
  String? pick;

  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        resizeToAvoidBottomInset: true,
        appBar: AppBar(
          elevation: 0.55,
          shadowColor: Color.fromRGBO(77, 32, 126, 1),
          bottomOpacity: 0,
          backgroundColor: Color.fromRGBO(77, 32, 126, 1),
          toolbarHeight: 80.h,
          title: Row(mainAxisAlignment: MainAxisAlignment.start, children: [
            Container(
                margin: EdgeInsets.only(top: 10),
                child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: Icon(Icons.arrow_back_ios))),
            SizedBox(
              width: 135,
            ),
            Text('โปรไฟล์',
                style: TextStyle(
                    fontFamily: 'DBHeavent',
                    fontSize: 30,
                    color: Colors.white)),
          ]),
        ),
        body: SizedBox(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          child: Stack(
            children: [
              Container(
                color: Color.fromRGBO(77, 32, 126, 1),
                height: 60.h,
              ),
              SingleChildScrollView(
                child: Container(
                  padding: EdgeInsets.only(top: 20, left: 25, right: 25),
                  margin: EdgeInsets.only(left: 15, right: 15, bottom: 40),
                  width: 400.h,
                  decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(10),
                      boxShadow: [
                        BoxShadow(
                            color: Colors.black.withOpacity(0.1),
                            spreadRadius: 3,
                            blurRadius: 6)
                      ]),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Stack(
                        children: [
                          Center(
                            child: CircleAvatar(
                              radius: 70,
                              backgroundImage: NetworkImage(
                                  'https://images.unsplash.com/photo-1534528741775-53994a69daeb?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NDV8fHBlcnNvbnxlbnwwfHwwfHw%3D&auto=format&fit=crop&w=600&q=60'),
                            ),
                          ),
                          Positioned(
                            left: 195,
                            top: 100,
                            child: Container(
                              width: 40,
                              height: 40,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(40),
                                color: Color.fromRGBO(241, 229, 253, 1),
                              ),
                              child: Icon(Icons.camera_alt_outlined,
                                  size: 20,
                                  color: Color.fromRGBO(77, 37, 124, 10)),
                            ),
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 10,
                      ),
                      Center(
                        child: Text(
                          'วริศรา มีความสุข',
                          style: TextStyle(
                            fontFamily: 'DBHeavent',
                            fontSize: 35,
                          ),
                        ),
                      ),
                      buildTextField('E-mail', 'E-mail', Colors.grey.shade100),
                      SizedBox(
                        height: 15,
                      ),
                      buildTextField(
                          'Username', 'Username', Colors.grey.shade100),
                      SizedBox(
                        height: 15,
                      ),
                      buildTextField('Password', 'Password', Colors.white),
                      SizedBox(
                        height: 10,
                      ),
                      Container(
                        margin: EdgeInsets.only(left: 250),
                        child: Text(
                          'แก้ไขรหัสผ่าน',
                          style: TextStyle(
                            decoration: TextDecoration.underline,
                            color: Color.fromRGBO(178, 31, 41, 1),
                            fontFamily: 'DBHeavent',
                            fontSize: 21,
                          ),
                        ),
                      ),
                      SizedBox(
                        height: 15,
                      ),
                      buildTextField('ชื่อ', 'ชื่อ', Colors.white),
                      SizedBox(
                        height: 15,
                      ),
                      buildTextField('นามสกุล', 'นามสกุล', Colors.white),
                      SizedBox(
                        height: 15,
                      ),
                      dropdown_gender(),
                      SizedBox(
                        height: 15,
                      ),
                      Row(
                        children: [
                          Text(
                            '*วัน/เดือน/ปีเกิด',
                            style: TextStyle(
                              fontFamily: 'DBHeavent',
                              fontSize: 25,
                              color: Color.fromRGBO(77, 37, 124, 1),
                            ),
                          ),
                          SizedBox(
                            width: 2.4,
                          ),
                          Container(
                            margin: EdgeInsets.only(top: 3),
                            child: Text(
                              '(ใช้สำหรับยืนยันตัวตน กรณีลืมหรัสผ่าน)',
                              style: TextStyle(
                                fontFamily: 'DBHeavent',
                                fontSize: 20,
                                color: Color.fromRGBO(178, 31, 41, 1),
                              ),
                            ),
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 8,
                      ),
                      Container(
                        width: double.infinity,
                        height: 50.h,
                        padding: EdgeInsets.only(right: 10, left: 20),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(30),
                          border: Border.all(color: Colors.grey.shade300),
                        ),
                        child: TextButton(
                          onPressed: () {
                            showDatePicker(
                                    context: context,
                                    initialDate: new DateTime.now(),
                                    firstDate:
                                        new DateTime(DateTime.now().year - 10),
                                    lastDate:
                                        new DateTime(DateTime.now().year + 10))
                                .then((date) {
                              setState(() {
                                _dateTime = date;
                              });
                            });
                          },
                          child: Row(
                            children: [
                              Text(
                                _dateTime == null
                                    ? 'เลือกตามปฏิทิน'
                                    : format.format(_dateTime!).toString(),
                                style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 22,
                                    color: Colors.grey.shade500),
                              ),
                              Expanded(child: SizedBox()),
                              Icon(
                                Icons.calendar_today_outlined,
                                size: 21.0,
                                color: Color.fromRGBO(77, 32, 126, 1),
                              ),
                            ],
                          ),
                        ),
                      ),
                      SizedBox(
                        height: 15,
                      ),
                      Text(
                        'ประเทศ',
                        style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 25,
                          color: Color.fromRGBO(77, 37, 124, 1),
                        ),
                      ),
                      SizedBox(
                        height: 8,
                      ),
                      Container(
                        padding: EdgeInsets.only(left: 15, right: 10),
                        width: double.infinity,
                        height: 50.h,
                        decoration: BoxDecoration(
                            border: Border.all(color: Colors.grey.shade300),
                            borderRadius: BorderRadius.circular(30)),
                        child: CountryCodePicker(
                          initialSelection: 'IN',
                          showCountryOnly: true,
                          showOnlyCountryWhenClosed: true,
                          showFlag: false,
                          showFlagDialog: true,
                          alignLeft: true,
                          enabled: true,
                          dialogSize: Size(350, 500),
                        ),
                      ),
                      SizedBox(
                        height: 15,
                      ),
                      dropdown_province(),
                      SizedBox(
                        height: 40,
                      ),
                      Botton(context),
                      SizedBox(
                        height: 30,
                      )
                    ],
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}

buildTextField(String topic, String hint, Color color) {
  return Column(
    crossAxisAlignment: CrossAxisAlignment.start,
    children: [
      Text(
        topic,
        style: TextStyle(
          fontFamily: 'DBHeavent',
          fontSize: 25,
          color: Color.fromRGBO(77, 37, 124, 1),
        ),
      ),
      SizedBox(
        height: 8,
      ),
      Container(
        height: 50.h,
        child: TextField(
          obscureText: false,
          decoration: InputDecoration(
              border: OutlineInputBorder(
                borderRadius: BorderRadius.circular(30),
              ),
              filled: true,
              contentPadding: EdgeInsets.only(
                left: 25,
              ),
              focusedBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey.shade300),
                borderRadius: BorderRadius.circular(30),
              ),
              enabledBorder: OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey.shade300),
                borderRadius: BorderRadius.circular(30),
              ),
              hintStyle: TextStyle(
                color: Colors.grey,
                fontFamily: 'DBHeavent',
                fontSize: 23,
              ),
              hintText: hint,
              fillColor: color),
        ),
      ),
    ],
  );
}

class dropdown_gender extends StatefulWidget {
  dropdown_gender({Key? key}) : super(key: key);

  @override
  State<dropdown_gender> createState() => _dropdownState();
}

class _dropdownState extends State<dropdown_gender> {
  List<String> gender = ['ชาย', 'หญิง'];
  List<String> province_th = [
    'กรุงเทพฯ',
    'กระบี่',
    'กาญจนบุรี',
    'กาฬสินธุ์',
    'กำแพงเพชร',
    'ขอนแก่น',
    'จันทบุรี',
    'ฉะเชิงเทรา',
    'ชลบุรี',
    'ชัยนาท',
    'ชัยภูมิ',
    'ชุมพร',
    'เชียงใหม่',
    'เชียงราย',
    'ตรัง',
    'ตราด',
    'ตาก',
    'นครนายก',
    'นครปฐม',
    'นครพนม',
    'นครราชสีมา',
    'นครศรีธรรมราช',
    'นครสวรรค์',
    'นนทบุรี',
    'นราธิวาส',
    'น่าน',
    'บึงกาฬ',
    'บุรีรัมย์',
    'ปทุมธานี',
    'ประจวบคีรีขันธ์',
    'ปราจีนบุรี',
    'ปัตตานี',
    'พระนครศรีอยุธยา',
    'พะเยา',
    'พังงา',
    'พัทลุง',
    'พิจิตร',
    'พิษณุโลก',
    'เพชรบุรี',
    'เพชรบูรณ์',
    'แพร่',
    'ภูเก็ต',
    'มหาสารคาม',
    'มุกดาหาร',
    'แม่ฮ่องสอน',
    'ยโสธร',
    'ยะลา',
    'ร้อยเอ็ด',
    'ระนอง',
    'ระยอง',
    'ราชบุรี',
    'ลพบุรี',
    'ลำปาง',
    'ลำพูน',
    'เลย',
    'ศรีสะเกษ',
    'สกลนคร',
    'สงขลา',
    'สตูล',
    'สมุทรปราการ',
    'สมุทรสงคราม',
    'สมุทรสาคร',
    'สระแก้ว',
    'สระบุรี',
    'สิงห์บุรี',
    'สุโขทัย',
    'สุพรรณบุรี',
    'สุราษฎร์ธานี',
    'สุรินทร์',
    'หนองคาย',
    'หนองบัวลำภู',
    'อ่างทอง',
    'อำนาจเจริญ',
    'อุดรธานี',
    'อุตรดิตถ์',
    'อุทัยธานี',
    'อุบลราชธานี',
  ];
  String? select;
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          'เพศ',
          style: TextStyle(
            fontFamily: 'DBHeavent',
            fontSize: 25,
            color: Color.fromRGBO(77, 37, 124, 1),
          ),
        ),
        SizedBox(
          height: 8,
        ),
        Container(
          padding: EdgeInsets.only(left: 25, right: 10),
          width: double.infinity,
          height: 50.h,
          decoration: BoxDecoration(
              border: Border.all(color: Colors.grey.shade300),
              borderRadius: BorderRadius.circular(30)),
          child: DropdownButtonHideUnderline(
            child: DropdownButton(
                isExpanded: true,
                icon: Icon(Icons.keyboard_arrow_down,
                    size: 35, color: Color.fromRGBO(77, 32, 126, 1)),
                hint: Text(
                  'เพศ',
                  style: TextStyle(
                    color: Colors.grey,
                    fontFamily: 'DBHeavent',
                    fontSize: 23,
                  ),
                ),
                dropdownColor: Colors.white,
                value: select,
                items: gender
                    .map((value) => DropdownMenuItem(
                        value: value,
                        child: Text(
                          value,
                          style: TextStyle(
                            fontFamily: 'DBHeavent',
                            fontSize: 23,
                          ),
                        )))
                    .toList(),
                onChanged: (value) {
                  setState(() {
                    select = value as String?;
                  });
                }),
          ),
        ),
      ],
    );
  }
}

class dropdown_province extends StatefulWidget {
  const dropdown_province({Key? key}) : super(key: key);

  @override
  State<dropdown_province> createState() => _dopdown_provinceState();
}

class _dopdown_provinceState extends State<dropdown_province> {
  List<String> province_th = [
    'กรุงเทพฯ',
    'กระบี่',
    'กาญจนบุรี',
    'กาฬสินธุ์',
    'กำแพงเพชร',
    'ขอนแก่น',
    'จันทบุรี',
    'ฉะเชิงเทรา',
    'ชลบุรี',
    'ชัยนาท',
    'ชัยภูมิ',
    'ชุมพร',
    'เชียงใหม่',
    'เชียงราย',
    'ตรัง',
    'ตราด',
    'ตาก',
    'นครนายก',
    'นครปฐม',
    'นครพนม',
    'นครราชสีมา',
    'นครศรีธรรมราช',
    'นครสวรรค์',
    'นนทบุรี',
    'นราธิวาส',
    'น่าน',
    'บึงกาฬ',
    'บุรีรัมย์',
    'ปทุมธานี',
    'ประจวบคีรีขันธ์',
    'ปราจีนบุรี',
    'ปัตตานี',
    'พระนครศรีอยุธยา',
    'พะเยา',
    'พังงา',
    'พัทลุง',
    'พิจิตร',
    'พิษณุโลก',
    'เพชรบุรี',
    'เพชรบูรณ์',
    'แพร่',
    'ภูเก็ต',
    'มหาสารคาม',
    'มุกดาหาร',
    'แม่ฮ่องสอน',
    'ยโสธร',
    'ยะลา',
    'ร้อยเอ็ด',
    'ระนอง',
    'ระยอง',
    'ราชบุรี',
    'ลพบุรี',
    'ลำปาง',
    'ลำพูน',
    'เลย',
    'ศรีสะเกษ',
    'สกลนคร',
    'สงขลา',
    'สตูล',
    'สมุทรปราการ',
    'สมุทรสงคราม',
    'สมุทรสาคร',
    'สระแก้ว',
    'สระบุรี',
    'สิงห์บุรี',
    'สุโขทัย',
    'สุพรรณบุรี',
    'สุราษฎร์ธานี',
    'สุรินทร์',
    'หนองคาย',
    'หนองบัวลำภู',
    'อ่างทอง',
    'อำนาจเจริญ',
    'อุดรธานี',
    'อุตรดิตถ์',
    'อุทัยธานี',
    'อุบลราชธานี',
  ];
  String? select;
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          'จังหวัด',
          style: TextStyle(
            fontFamily: 'DBHeavent',
            fontSize: 25,
            color: Color.fromRGBO(77, 37, 124, 1),
          ),
        ),
        SizedBox(
          height: 8,
        ),
        Container(
          padding: EdgeInsets.only(left: 25, right: 10),
          width: double.infinity,
          height: 50.h,
          decoration: BoxDecoration(
              border: Border.all(color: Colors.grey.shade300),
              borderRadius: BorderRadius.circular(30)),
          child: DropdownButtonHideUnderline(
            child: DropdownButton(
                isExpanded: true,
                icon: Icon(Icons.keyboard_arrow_down,
                    size: 35, color: Color.fromRGBO(77, 32, 126, 1)),
                hint: Text(
                  'จังหวัด',
                  style: TextStyle(
                    color: Colors.grey,
                    fontFamily: 'DBHeavent',
                    fontSize: 23,
                  ),
                ),
                dropdownColor: Colors.white,
                value: select,
                items: province_th
                    .map((value) => DropdownMenuItem(
                        value: value,
                        child: Text(
                          value,
                          style: TextStyle(
                            fontFamily: 'DBHeavent',
                            fontSize: 23,
                          ),
                        )))
                    .toList(),
                onChanged: (value) {
                  setState(() {
                    select = value as String?;
                  });
                }),
          ),
        ),
      ],
    );
  }
}

Widget Botton(BuildContext context) {
  return GestureDetector(
    onTap: () {},
    child: Container(
      height: 50,
      width: MediaQuery.of(context).size.width,
      decoration: BoxDecoration(
          gradient: LinearGradient(colors: [
            Color.fromRGBO(122, 79, 159, 1),
            Color.fromRGBO(77, 32, 126, 1)
          ], begin: Alignment.topCenter, end: Alignment.bottomCenter),
          color: Color.fromRGBO(77, 37, 124, 1),
          borderRadius: BorderRadius.circular(30)),
      child: Center(
        child: Text(
          'ยืนยัน',
          style: TextStyle(
            fontFamily: 'DBHeavent',
            fontSize: 25,
            color: Colors.white,
          ),
        ),
      ),
    ),
  );
}
