import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_slider_drawer/flutter_slider_drawer.dart';
import 'package:nbt_app/components/bottombar.dart';
import 'package:nbt_app/globalvariables/global_variables.dart';
import 'package:nbt_app/screen/catch%20up/catchup_page.dart';
import 'package:nbt_app/screen/history/history_page.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/home/home_search.dart';
import 'package:nbt_app/screen/livetv/tvonline_page.dart';
import 'package:nbt_app/screen/login/login_page.dart';
import 'package:nbt_app/screen/news/news_page.dart';
import 'package:nbt_app/screen/notification/FavouriteList_Page.dart';
import 'package:nbt_app/screen/notification/notification_page.dart';
import 'package:nbt_app/screen/programs/programs_page.dart';
import 'package:nbt_app/screen/register/register_page.dart';
import 'package:nbt_app/screen/setting/setting_page.dart';

class AppBarLogo extends StatefulWidget {
  bool isShowBackButton;

  AppBarLogo({
    this.isShowBackButton = true,
  });

  @override
  _AppBarLogoState createState() => _AppBarLogoState();
}

class _AppBarLogoState extends State<AppBarLogo> {
  GlobalKey<SliderDrawerState> _key = GlobalKey<SliderDrawerState>();
  // final screens = [
  //   const HomePage(),
  //   const TvOnlinePage(),
  //   const NewsPage(),
  //   const ProgramsPage(),
  //   const CatchupPage()
  // ];

  @override
  Widget build(BuildContext context) {

    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);

    return PreferredSize(
      preferredSize: Size.fromHeight(80),
      child: AppBar(
        elevation: 0,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(child: SizedBox()),
                SizedBox(
                  width: 10.w,
                ),
                Image.asset(
                  'assets/images/title_logo.png',
                  fit: BoxFit.contain,
                  height: 80,
                  width: 80,
                ),
                Expanded(child: SizedBox()),
                GestureDetector(
                  onTap: () {
                    setState(() {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => NotificationPage()));
                    });
                  },
                  child: Icon(Icons.notifications_none),
                ),
                SizedBox(
                  width: 10.w,
                ),
                GestureDetector(
                    onTap: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => const HomeSearchPage()));
                    },
                    child: Icon(Icons.search)),
              ],
            ),
      ),
    );

    // ScreenUtil.init(
    //     BoxConstraints(
    //         maxWidth: MediaQuery.of(context).size.width,
    //         maxHeight: MediaQuery.of(context).size.height),
    //     designSize: Size(360, 690),
    //     context: context,
    //     minTextAdapt: true,
    //     orientation: Orientation.portrait);
    // return MaterialApp(
    //   debugShowCheckedModeBanner: false,
    //   home: Scaffold(
    //     appBar: AppBar(
    //       elevation: 0,
    //       shadowColor: Color.fromRGBO(77, 32, 126, 1),
    //       bottomOpacity: 0,
    //       backgroundColor: Color.fromRGBO(77, 32, 126, 1),
    //       toolbarHeight: 80.h,
    //       title: Row(
    //         mainAxisAlignment: MainAxisAlignment.center,
    //         children: [
    //           SizedBox(
    //             width: 100.w,
    //           ),
    //           Image.asset(
    //             'assets/images/title_logo.png',
    //             fit: BoxFit.contain,
    //             height: 80,
    //             width: 80,
    //           ),
    //           SizedBox(
    //             width: 50.w,
    //           ),
    //           GestureDetector(
    //             onTap: () {
    //               setState(() {
    //                 Navigator.push(
    //                     context,
    //                     MaterialPageRoute(
    //                         builder: (context) => NotificationPage()));
    //               });
    //             },
    //             child: Icon(Icons.notifications_none),
    //           ),
    //           SizedBox(
    //             width: 10.w,
    //           ),
    //           GestureDetector(
    //               onTap: () {
    //                 Navigator.push(
    //                     context,
    //                     MaterialPageRoute(
    //                         builder: (context) => const HomeSearchPage()));
    //               },
    //               child: Icon(Icons.search)),
    //         ],
    //       ),
    //     ),
    //     //body: const HomePage(),
    //     //body: const BottomBar(),
    //     //bottomNavigationBar: const BottomBar(),
    //     // drawer: Drawer(
    //     //   backgroundColor: Color.fromRGBO(77, 32, 126, 1),
    //     //   child: SingleChildScrollView(
    //     //     child: notMember(),
    //     //   ),
    //     // ),
    //   ),
    // );
  }

  
}
