import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_title.dart';
import 'package:nbt_app/screen/register/register_complete_page.dart';

class RegisterPage extends StatefulWidget {
  const RegisterPage({Key? key}) : super(key: key);

  @override
  _RegisterPageState createState() => _RegisterPageState();
}

class _RegisterPageState extends State<RegisterPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: AppBar(
        elevation: 0.55,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: AppbarTitle(
          title: 'ลงทะเบียน / ยืนยันตัวตน',
        ),
      ),
      body: Stack(
        children: [
          Container(
            color: Color.fromRGBO(77, 32, 126, 1),
            height: 50.h,
          ),
          SingleChildScrollView(
            child: Container(
              margin: EdgeInsets.only(left: 15.h, right: 15.h),
              width: MediaQuery.of(context).size.width,
              decoration: BoxDecoration(
                border: Border.all(
                  color: Colors.white,
                  style: BorderStyle.solid,
                  width: 1.0,
                ),
                color: Colors.white,
                borderRadius: BorderRadius.circular(10.0),
              ),
              child: Column(
                children: [
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 30),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "Email",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  Email",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "Username",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  Username",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "Password",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          suffixIcon: Icon(
                            Icons.remove_red_eye_outlined,
                            color: Colors.grey,
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  Password",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "ชื่อ",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  ชื่อ",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "นามสกุล",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  นามสกุล",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "เพศ",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          suffixIcon: Icon(
                            Icons.arrow_drop_down,
                            color: Colors.grey,
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  เพศ",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "วัน / เดือน / ปี",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          suffixIcon: Icon(
                            Icons.calendar_today,
                            color: Colors.grey,
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  วว/ดด/ปป",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "ประเทศ",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          suffixIcon: Icon(
                            Icons.arrow_drop_down,
                            color: Colors.grey,
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  ประเทศ",
                          fillColor: Colors.white),
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(left: 20, top: 10),
                    alignment: Alignment.topLeft,
                    child: Text(
                      "จังหวัด",
                      textAlign: TextAlign.left,
                      style: TextStyle(
                        color: Color.fromRGBO(77, 32, 126, 1),
                        fontFamily: 'DBHeavent',
                        fontSize: 25,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  Container(
                    height: 40.h,
                    padding: EdgeInsets.only(left: 20, right: 20, top: 10),
                    child: TextField(
                      decoration: InputDecoration(
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(30.0),
                          ),
                          suffixIcon: Icon(
                            Icons.arrow_drop_down,
                            color: Colors.grey,
                          ),
                          filled: true,
                          contentPadding: EdgeInsets.only(
                              left: 14.0, bottom: 0.0, top: 8.0),
                          focusedBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderSide: BorderSide(color: Colors.grey),
                            borderRadius: BorderRadius.circular(25.7),
                          ),
                          hintStyle: TextStyle(
                            color: Colors.grey,
                            fontFamily: 'DBHeavent',
                            fontSize: 25,
                            fontWeight: FontWeight.w500,
                          ),
                          hintText: "  จังหวัด",
                          fillColor: Colors.white),
                    ),
                  ),
                  _loginButton(),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _loginButton() {
    return Padding(
      padding: EdgeInsets.only(left: 20, right: 20, top: 50, bottom: 50),
      child: RaisedButton(
        shape: new RoundedRectangleBorder(
            borderRadius: new BorderRadius.circular(30.0)),
        child: Container(
          alignment: Alignment.center,
          height: 40.h,
          width: double.infinity,
          child: Text(
            "ยืนยัน",
            style: TextStyle(
              fontSize: 30,
              fontWeight: FontWeight.w500,
              fontFamily: 'DBHeavent',
              color: Colors.white,
            ),
          ),
        ),
        color: Color.fromRGBO(77, 32, 126, 1),
        onPressed: () {
          Navigator.push(context,
              MaterialPageRoute(builder: (context) => RegisterCompletePage()));
        },
      ),
    );
  }
}
