import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:carousel_slider/carousel_slider.dart';
import 'package:smooth_page_indicator/smooth_page_indicator.dart';

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class CardItem {
  String url, title, date, view, des;

  CardItem(
      {required this.url,
      required this.title,
      required this.date,
      required this.view,
      required this.des});
}

List<CardItem> cardItems = [
  CardItem(
      url:
          'https://images.unsplash.com/photo-1643288178515-8b4ba815313a?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHwxMHx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'title1',
      date: '15/05/20',
      view: '100',
      des: 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'),
  CardItem(
      url:
          'https://images.unsplash.com/photo-1640622658353-c6cecbe91488?ixlib=rb-1.2.1&ixid=MnwxMjA3fDF8MHxlZGl0b3JpYWwtZmVlZHwxMXx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'title2',
      date: '20/06/20',
      view: '200',
      des: 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'),
  CardItem(
      url:
          'https://images.unsplash.com/photo-1638913974023-cef988e81629?ixlib=rb-1.2.1&ixid=MnwxMjA3fDF8MHxlZGl0b3JpYWwtZmVlZHwxNnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'title3',
      date: '54/20/20',
      view: '300',
      des: 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'),
  CardItem(
      url:
          'https://images.unsplash.com/photo-1638555063519-d009e6f3b28b?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHwyMnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'title4',
      date: '20/02/21',
      view: '400',
      des: 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA')
];

class _HomePageState extends State<HomePage> {
  int activeIndex = 0;
  List list = [1, 2, 3, 4, 5];

  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);

    return Scaffold(
      // backgroundColor: Color.fromRGBO(77, 32, 126, 1),
      body: Column(
        children: [
          Stack(alignment: Alignment.topCenter, children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60.h,
            ),
            CarouselSlider(
                options: CarouselOptions(
                    viewportFraction: 1.1,
                    onPageChanged: (index, reason) =>
                        setState(() => activeIndex = index)),
                items: cardItems.map((e) => MainSlide()).toList())
          ]),
          SizedBox(
            height: 12,
          ),
          Container(margin: EdgeInsets.only(top: 10), child: buildIndicator()),
          SizedBox(
            height: 17,
          ),
          Expanded(
            child: SingleChildScrollView(
              child: Container(
                padding: EdgeInsets.only(left: 15),
                child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Text(
                            'รายการยอดวิวสูง',
                            style: TextStyle(
                                fontSize: 38, fontFamily: 'DBHeavent'),
                          ),
                          SizedBox(
                            width: 150,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        height: 180,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 10,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardImage(item: cardItems[index]);
                            }),
                      ),
                      underline(20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Text(
                            'ข่าวเด็ดประเทศไทย',
                            style: TextStyle(
                                fontSize: 38, fontFamily: 'DBHeavent'),
                          ),
                          SizedBox(
                            width: 143,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        width: MediaQuery.of(context).size.width,
                        height: 35,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardTitles.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 5,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardTitle(item: cardTitles[index]);
                            }),
                      ),
                      SizedBox(
                        height: 20,
                      ),
                      Container(
                          margin: EdgeInsets.only(right: 15),
                          height: 250,
                          width: MediaQuery.of(context).size.width,
                          child: ClipRRect(
                              borderRadius: BorderRadius.circular(10),
                              child: Image.network(
                                'https://images.unsplash.com/photo-1580519542036-c47de6196ba5?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NXx8bW9uZXl8ZW58MHx8MHx8&auto=format&fit=crop&w=600&q=60',
                                fit: BoxFit.cover,
                              ))),
                      SizedBox(
                        height: 5,
                      ),
                      Row(
                        children: [
                          Text(
                            '20/02/21',
                            style: TextStyle(
                                color: Colors.grey.shade500, fontSize: 15),
                          ),
                          SizedBox(
                            width: 5,
                          ),
                          Icon(
                            Icons.remove_red_eye,
                            size: 13,
                            color: Colors.grey.shade500,
                          ),
                          SizedBox(
                            width: 5,
                          ),
                          Text(
                            '1000',
                            style: TextStyle(
                                color: Colors.grey.shade500, fontSize: 15),
                          ),
                        ],
                      ),
                      Text(
                        'ดีกรีแชมป์เจลีก! “ชนาธิป” ได้ล่ามคนใหม่ “นริศ” อดีตคู่หู “ธีราทร”',
                        style: TextStyle(fontSize: 20),
                      ),
                      underline(20, 20),
                      Container(
                        child: ListView.builder(
                            padding: EdgeInsets.only(top: 5),
                            scrollDirection: Axis.vertical,
                            shrinkWrap: true,
                            itemCount: cardItems.length,
                            itemBuilder: (context, index) {
                              return buildRoundedCard(item: cardItems[index]);
                            }),
                      ),
                      underline(20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Text(
                            'ข่าวล่าสุด',
                            style: TextStyle(
                                fontSize: 38, fontFamily: 'DBHeavent'),
                          ),
                          SizedBox(
                            width: 237,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        height: 215,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 10,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardSubImage(item: cardItems[index]);
                            }),
                      ),
                      underline(20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Text(
                            'ข่าวช่อง NBT',
                            style: TextStyle(
                                fontSize: 38, fontFamily: 'DBHeavent'),
                          ),
                          SizedBox(
                            width: 200,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        height: 215,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 10,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardSubImage(item: cardItems[index]);
                            }),
                      ),
                      underline(20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Container(
                            width: 320,
                            child: SingleChildScrollView(
                              scrollDirection: Axis.horizontal,
                              child: Text(
                                'รายการทั้งหมดช่อง NBT Digital 2HD',
                                maxLines: 1,
                                style: TextStyle(
                                    fontSize: 38, fontFamily: 'DBHeavent'),
                              ),
                            ),
                          ),
                          SizedBox(
                            width: 19,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        height: 180,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 10,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardImage(item: cardItems[index]);
                            }),
                      ),
                      underline(20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Text(
                            'ข่าวประชาสัมพันธ์',
                            style: TextStyle(
                                fontSize: 38, fontFamily: 'DBHeavent'),
                          ),
                          SizedBox(
                            width: 150,
                          ),
                          GestureDetector(
                            onTap: () {},
                            child: Text('ดูทั้งหมด',
                                style: TextStyle(
                                    fontSize: 22,
                                    color: Color.fromRGBO(77, 32, 126, 1),
                                    fontFamily: 'DBHeavent')),
                          ),
                        ],
                      ),
                      Container(
                        height: 215,
                        child: ListView.separated(
                            padding: EdgeInsets.only(top: 6),
                            scrollDirection: Axis.horizontal,
                            itemCount: cardItems.length,
                            separatorBuilder: (context, position) => SizedBox(
                                  width: 10,
                                ),
                            itemBuilder: (context, index) {
                              return buildCardSubImage(item: cardItems[index]);
                            }),
                      ),
                    ]),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget buildIndicator() => AnimatedSmoothIndicator(
        activeIndex: activeIndex,
        count: cardItems.length,
        effect: ScrollingDotsEffect(
            activeDotColor: Color.fromRGBO(77, 32, 126, 1),
            activeDotScale: 1,
            activeStrokeWidth: 1,
            maxVisibleDots: 5,
            dotHeight: 10,
            dotWidth: 10),
      );
}

Widget buildCardImage({required CardItem item}) => Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
            height: 120,
            width: 180,
            child: ClipRRect(
                borderRadius: BorderRadius.circular(10),
                child: Image.network(
                  item.url,
                  fit: BoxFit.cover,
                ))),
        Container(
          margin: EdgeInsets.only(top: 5),
          child: Row(
            children: [
              Text(
                item.date,
                style: TextStyle(color: Colors.grey.shade500, fontSize: 15),
              ),
              SizedBox(
                width: 5,
              ),
              Icon(
                Icons.remove_red_eye,
                size: 15,
                color: Colors.grey.shade500,
              ),
              SizedBox(
                width: 5,
              ),
              Text(
                item.view,
                style: TextStyle(color: Colors.grey.shade500, fontSize: 15),
              ),
            ],
          ),
        ),
        Container(
          width: 180,
          child: Text(
            item.title,
            softWrap: false,
            style: TextStyle(fontSize: 20),
          ),
        ),
      ],
    );

Widget underline(double top, double bottom) {
  return Container(
    margin: EdgeInsets.only(right: 15, top: top, bottom: bottom),
    decoration: BoxDecoration(
        border:
            Border(bottom: BorderSide(color: Colors.grey.shade300, width: 2))),
  );
}

class CardTitle {
  String title;

  CardTitle({required this.title});
}

List<CardTitle> cardTitles = [
  CardTitle(title: '#โควิท'),
  CardTitle(title: '#การเมือง'),
  CardTitle(title: '#เทคโนโลยี'),
  CardTitle(title: '#ธรรมชาติ'),
  CardTitle(title: '#ฟุตบอล'),
  CardTitle(title: '#คุยถึงแก่น'),
  CardTitle(title: '#สภาพอากาศ'),
];

Widget buildCardTitle({required CardTitle item}) => Container(
      padding: EdgeInsets.only(top: 3, left: 10, right: 10),
      decoration: BoxDecoration(
          color: Color.fromRGBO(241, 229, 253, 1),
          borderRadius: BorderRadius.circular(30)),
      child: Text(
        item.title,
        style: TextStyle(fontSize: 15, color: Color.fromRGBO(77, 37, 124, 1)),
      ),
    );
Widget buildRoundedCard({required CardItem item}) => Column(
      children: [
        Container(
          height: 100,
          child: Row(
            children: [
              Container(
                  width: 170,
                  child: Container(
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(5),
                        image: DecorationImage(
                            image: NetworkImage(item.url), fit: BoxFit.cover)),
                  )),
              Padding(padding: EdgeInsets.only(left: 12)),
              Container(
                // color: Colors.yellow,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                      margin: EdgeInsets.only(top: 7),
                      child: Row(
                        children: [
                          Text(item.date,
                              style: TextStyle(
                                color: Colors.grey.shade500,
                                fontSize: 15,
                              )),
                          SizedBox(
                            width: 5,
                          ),
                          Icon(
                            Icons.remove_red_eye,
                            size: 13,
                            color: Colors.grey.shade500,
                          ),
                          SizedBox(
                            width: 5,
                          ),
                          Text(item.view,
                              style: TextStyle(
                                  color: Colors.grey.shade500, fontSize: 15))
                        ],
                      ),
                    ),
                    Container(
                      height: 60,
                      width: 214,
                      child: Text(
                        '1 นาที กับงานกาชาด “ งานกาชาดออนไลน์ประจำปี 2564',
                        softWrap: true,
                        maxLines: 2,
                        style: TextStyle(
                            fontSize: 25, fontFamily: 'DBHeavent', height: 1),
                      ),
                    ),
                    Container(
                      child: Row(
                        children: [
                          Icon(
                            Icons.share,
                            size: 15,
                            color: Color.fromRGBO(77, 32, 126, 1),
                          ),
                          SizedBox(
                            width: 10,
                          ),
                          Icon(Icons.favorite_border,
                              size: 15, color: Color.fromRGBO(77, 32, 126, 1))
                        ],
                      ),
                    )
                  ],
                ),
              ),
            ],
          ),
        ),
        SizedBox(
          height: 10,
        ),
      ],
    );
Widget buildCardSubImage({required CardItem item}) => Container(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
              height: 160,
              width: 280,
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(10),
                  child: Image.network(
                    item.url,
                    fit: BoxFit.cover,
                  ))),
          Container(
            margin: EdgeInsets.only(top: 5),
            child: Row(
              children: [
                Text(
                  item.date,
                  style: TextStyle(color: Colors.grey.shade500, fontSize: 15),
                ),
                SizedBox(
                  width: 5,
                ),
                Icon(
                  Icons.remove_red_eye,
                  size: 15,
                  color: Colors.grey.shade500,
                ),
                SizedBox(
                  width: 5,
                ),
                Text(
                  item.view,
                  style: TextStyle(color: Colors.grey.shade500, fontSize: 15),
                ),
              ],
            ),
          ),
          Container(
            width: 280,
            child: Text(
              item.title,
              softWrap: false,
              maxLines: 1,
              style: TextStyle(fontSize: 20),
            ),
          ),
        ],
      ),
    );

Widget MainSlide() => ClipRRect(
      borderRadius: BorderRadius.circular(15),
      child: Stack(
        children: [
          Container(
            height: 250.h,
            width: 380,
            decoration: BoxDecoration(
                image: DecorationImage(
                    image: NetworkImage(
                        'https://images.unsplash.com/photo-1646061632529-b552ea07b50b?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHw0MXx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60'),
                    fit: BoxFit.cover)),
          ),
          Positioned(
              bottom: 0.0,
              left: 0.0,
              right: 0.0,
              child: Container(
                height: 130,
                decoration: BoxDecoration(
                  gradient: LinearGradient(
                    colors: [
                      Color.fromARGB(200, 0, 0, 0),
                      Color.fromARGB(0, 0, 0, 0)
                    ],
                    begin: Alignment.bottomCenter,
                    end: Alignment.topCenter,
                  ),
                ),
                padding: EdgeInsets.only(top: 45, left: 25),
                child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        'TITLE',
                        style: TextStyle(
                            fontSize: 30,
                            color: Colors.white,
                            fontFamily: 'DBHeavent'),
                      ),
                      Row(
                        children: [
                          Expanded(
                            child: Text(
                              'Description',
                              maxLines: 1,
                              style: TextStyle(
                                fontSize: 25,
                                color: Colors.white,
                                fontFamily: 'DBHeavent',
                                height: 1,
                              ),
                            ),
                          ),
                        ],
                      )
                    ]),
              )),
        ],
      ),
    );
