import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_logo.dart';
import 'package:nbt_app/components/appbar_title.dart';

class SettingPage extends StatefulWidget {
  const SettingPage({Key? key}) : super(key: key);

  @override
  _SettingPageState createState() => _SettingPageState();
}

class _SettingPageState extends State<SettingPage> {
  bool isSwitched = false;

  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Scaffold(
      appBar: AppBar(
        elevation: 0.55,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: AppbarTitle(
          title: 'การตั้งค่า',
        ),
      ),
      body: Stack(
        children: [
          Container(
            color: Color.fromRGBO(77, 32, 126, 1),
            height: 50.h,
          ),
          Container(
            margin: EdgeInsets.only(left: 15.h, right: 15.h),
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              border: Border.all(
                color: Colors.white,
                style: BorderStyle.solid,
                width: 1.0,
              ),
              color: Colors.white,
              borderRadius: BorderRadius.circular(10.0),
            ),
            child: Column(
              children: [
                SizedBox(
                  height: 10,
                ),
                Row(
                  children: [
                    Container(
                      child: Text(
                        'การแจ้งเตือนข้อความ',
                        style: TextStyle(
                          color: Colors.black,
                          // color: Color.fromRGBO(77, 32, 126, 1),
                          fontFamily: 'DBHeavent',
                          fontSize: 24,
                          fontWeight: FontWeight.w500,
                          letterSpacing: 1,
                        ),
                      ),
                      margin: EdgeInsets.only(top: 10, left: 30),
                      alignment: Alignment.topLeft,
                    ),
                    Spacer(),
                    Container(
                      margin: EdgeInsets.only(top: 10, left: 10),
                      child: Transform.scale(
                        scale: 1.5,
                        child: Switch(
                          activeColor: Color.fromRGBO(77, 32, 126, 1),
                          value: isSwitched,
                          onChanged: (value) {
                            setState(() {
                              isSwitched = value;
                            });
                          },
                        ),
                      ),
                    ),
                    SizedBox(
                      width: 30,
                    ),
                  ],
                ),
                Row(
                  children: [
                    Container(
                      child: Text(
                        'การแจ้งเตือนข้อความ',
                        style: TextStyle(
                          color: Colors.black,
                          // color: Color.fromRGBO(77, 32, 126, 1),
                          fontFamily: 'DBHeavent',
                          fontSize: 24,
                          fontWeight: FontWeight.w500,
                          letterSpacing: 1,
                        ),
                      ),
                      margin: EdgeInsets.only(top: 0, left: 30),
                      alignment: Alignment.topLeft,
                    ),
                    Spacer(),
                    Container(
                      margin: EdgeInsets.only(top: 0, left: 10),
                      child: Transform.scale(
                        scale: 1.5,
                        child: Switch(
                          activeColor: Color.fromRGBO(77, 32, 126, 1),
                          value: isSwitched,
                          onChanged: (value) {
                            setState(() {
                              isSwitched = value;
                            });
                          },
                        ),
                      ),
                    ),
                    SizedBox(
                      width: 30,
                    ),
                  ],
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
