import 'package:flutter/material.dart';
import 'package:nbt_app/screen/catch%20up/catchup_page.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/livetv/tvonline_page.dart';
import 'package:nbt_app/screen/news/news_page.dart';
import 'package:nbt_app/screen/programs/programs_page.dart';

import '../globalvariables/global_variables.dart';

class BottomBar extends StatefulWidget {
  const BottomBar({Key? key}) : super(key: key);

  @override
  State<BottomBar> createState() => _BottomBarState();
}

class _BottomBarState extends State<BottomBar> {
  int _selectedIndex = 0;
  int tabIndex = 0;
  var argumentIndex = null;

  late List<Widget> containTab;



  // void _onItemTapped(int index) {
  //   setState(() {
  //     selectedIndex = index;
  //     argumentIndex = index;
  //   });
  // }

  @override
  Widget build(BuildContext context) {
    var checkArguments = ModalRoute.of(context)!.settings.arguments;

    containTab = [
      HomePage(),
      TvOnlinePage(),
      NewsPage(),
      ProgramsPage(),
      CatchupPage()
    ];

    // if (checkArguments != null) {
    //   final arguments = checkArguments as Map;
    //   if (argumentIndex == null) {
    //     argumentIndex = arguments['index'];
    //   } else {
    //     arguments['index'] = argumentIndex;
    //   }
    //   // print('arguments ${arguments}');
    //   _onItemTapped(argumentIndex);
    // }

    // return SizedBox(
    //   height: 100,
    //   child: BottomNavigationBar(
    //       type: BottomNavigationBarType.fixed,
    //       selectedItemColor: Color(0xFF4D207E),
    //       unselectedItemColor: Color(0xFFA19FA3),
    //       selectedLabelStyle: TextStyle(fontSize: 15, fontFamily: 'DBHeavent'),
    //       unselectedLabelStyle:
    //           TextStyle(fontSize: 15, fontFamily: 'DBHeavent'),
    //       showSelectedLabels: true,
    //       showUnselectedLabels: true,
    //       currentIndex: selectedIndex,
    //       onTap: _onItemTapped,
    //       items: const [
    //         BottomNavigationBarItem(icon: Icon(Icons.home), label: 'หน้าหลัก'),
    //         BottomNavigationBarItem(
    //             icon: Icon(Icons.live_tv), label: 'ทีวีออนไลน์'),
    //         BottomNavigationBarItem(icon: Icon(Icons.feed), label: 'ข่าว'),
    //         BottomNavigationBarItem(
    //             icon: Icon(Icons.video_collection), label: 'รายการ'),
    //         BottomNavigationBarItem(
    //             icon: Icon(Icons.video_label), label: 'Catch up'),
    //       ]),
    // );
    return Scaffold(
      body: Stack(
        children: [
          Container(
            margin: EdgeInsets.only(top: 10),
            // color: Colors.red,
            child: Column(
              children: [
                _contain(),
              ],
            ),
          ),
          _buttonNavigation(),
        ],
      ),
    );
  }

  Future <Function> changeTap (tabIndex) {
    //return
    setState(() {
      _selectedIndex = tabIndex;
    });

    return tabIndex;
  }

  Widget _contain() {
    return Expanded(
      child: Container(
        child: containTab[_selectedIndex],
      ),
    );
  }

  Widget _buttonNavigation() {
    return Container(
      margin: EdgeInsets.only(
        top: MediaQuery.of(context).size.height-80,
      ),
      padding: EdgeInsets.only(
          right: 30, left: 30),
      height: 80,
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(25),
          topRight: Radius.circular(25),
        ),
        boxShadow: [
          BoxShadow(
            color: Colors.grey.withOpacity(0.1),
            spreadRadius: 5,
            blurRadius: 7,
            offset: Offset(0, 3), // changes position of shadow
          ),
        ],
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          InkWell(
            onTap: () {
              setState(() {
                _selectedIndex = 0;
              });
            },
            child: Expanded(
              child: Container(
                width: 50,
                // color: Colors.red,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(2.0),
                      child: Icon(
                        Icons.home_outlined,
                        size: 30,
                        color: _selectedIndex == 0 ? Color(0xFF4D207E) : Colors.grey,
                      ),
                    ),
                    Text(
                      "หน้าหลัก",
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          fontSize: 15,
                          fontFamily: 'DBHeavent',
                          color: _selectedIndex == 0 ? Color(0xFF4D207E) : Colors.grey),
                    ),
                  ],
                ),
              ),
            ),
          ),
          InkWell(
            onTap: () {
              setState(() {
                _selectedIndex = 1;
              });
            },
            child: Expanded(
              child: Container(
                width: 50,
                // color: Colors.red,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(2.0),
                      child: Icon(
                        Icons.live_tv,
                        size: 30,
                        color: _selectedIndex == 1 ? Color(0xFF4D207E) : Colors.grey,
                      ),
                    ),
                    Text(
                      "ทีวีออนไลน์",
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          fontSize: 15,
                          fontFamily: 'DBHeavent',
                          color: _selectedIndex == 1 ? Color(0xFF4D207E) : Colors.grey),
                    ),
                  ],
                ),
              ),
            ),
          ),
          InkWell(
            onTap: () {
              setState(() {
                _selectedIndex = 2;
              });
            },
            child: Expanded(
              child: Container(
                width: 50,
                // color: Colors.red,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(2.0),
                      child: Icon(
                        Icons.feed,
                        size: 30,
                        color: _selectedIndex == 2 ? Color(0xFF4D207E) : Colors.grey,
                      ),
                    ),
                    Text(
                      "ข่าว",
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          fontSize: 15,
                          fontFamily: 'DBHeavent',
                          color: _selectedIndex == 2 ? Color(0xFF4D207E) : Colors.grey),
                    ),
                  ],
                ),
              ),
            ),
          ),
          InkWell(
            onTap: () {
              setState(() {
                _selectedIndex = 3;
              });
            },
            child: Expanded(
              child: Container(
                width: 50,
                // color: Colors.red,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(2.0),
                      child: Icon(
                        Icons.video_collection,
                        size: 30,
                        color: _selectedIndex == 3 ? Color(0xFF4D207E) : Colors.grey,
                      ),
                    ),
                    Text(
                      "รายการ",
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          fontSize: 15,
                          fontFamily: 'DBHeavent',
                          color: _selectedIndex == 3 ? Color(0xFF4D207E) : Colors.grey),
                    ),
                  ],
                ),
              ),
            ),
          ),
          InkWell(
            onTap: () {
              setState(() {
                _selectedIndex = 4;
              });
            },
            child: Expanded(
              child: Container(
                width: 50,
                // color: Colors.red,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(2.0),
                      child: Icon(
                        Icons.video_label,
                        size: 30,
                        color: _selectedIndex == 4 ? Color(0xFF4D207E) : Colors.grey,
                      ),
                    ),
                    Text(
                      "Catch up",
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          fontSize: 15,
                          fontFamily: 'DBHeavent',
                          color: _selectedIndex == 4 ? Color(0xFF4D207E) : Colors.grey),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

}
