import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_logo.dart';

class NotificationPage extends StatefulWidget {
  const NotificationPage({Key? key}) : super(key: key);

  @override
  _NotificationPageState createState() => _NotificationPageState();
}

class _NotificationPageState extends State<NotificationPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        home: Scaffold(
          appBar: AppBar(
            elevation: 0.55,
            shadowColor: Color.fromRGBO(77, 32, 126, 1),
            bottomOpacity: 0,
            backgroundColor: Color.fromRGBO(77, 32, 126, 1),
            toolbarHeight: 80.h,
            title: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Container(
                  margin: EdgeInsets.only(top: 10),
                  child: GestureDetector(
                    onTap: () {
                      setState(() {
                        Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => AppBarLogo()));
                        // Navigator.pop(context);
                      });
                    },
                    child: Icon(Icons.arrow_back_ios),
                  ),
                ),
                SizedBox(
                  width: 115,
                ),
                Container(
                  margin: EdgeInsets.only(top: 10),
                  child: Text(
                    'การแจ้งเตือน',
                    style: TextStyle(
                        fontSize: 30,
                        letterSpacing: 1,
                        fontWeight: FontWeight.w700,
                        // color: Color.fromRGBO(77, 32, 126, 1),
                        color: Colors.white,
                        fontFamily: 'DBHeavent'),
                  ),
                )
              ],
            ),
          ),
          body: Container(
            width: MediaQuery.of(context).size.width,
            height: MediaQuery.of(context).size.height,
            child: Stack(alignment: AlignmentDirectional.topStart, children: [
              Container(
                color: Color.fromRGBO(77, 32, 126, 1),
                height: 60.h,
              ),
              ListView.separated(
                  scrollDirection: Axis.vertical,
                  itemBuilder: (context, index) {
                    return buildCard(item: listitem[index]);
                  },
                  separatorBuilder: (context, position) => SizedBox(
                        height: 10,
                      ),
                  itemCount: listitem.length),
            ]),
          ),
        ));
  }
}

Widget buildCard({required Model item}) => Container(
      child: Column(
        children: [
          Container(
            height: 100,
            width: 385,
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(15),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                      color: Colors.black.withOpacity(0.14),
                      spreadRadius: 0.5,
                      blurRadius: 6,
                      offset: Offset(0, 3))
                ]),
            child: Row(
              children: [
                SizedBox(
                  width: 10,
                ),
                Container(
                  width: 125,
                  height: 80,
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(5),
                      image: DecorationImage(
                          image: NetworkImage(item.image), fit: BoxFit.cover)),
                ),
                SizedBox(
                  width: 15,
                ),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                      height: 70,
                      padding: EdgeInsets.only(top: 7),
                      width: 220,
                      // color: Colors.red,
                      child: Text(
                        item.title,
                        maxLines: 2,
                        softWrap: true,
                        style: TextStyle(
                            fontSize: 22,
                            letterSpacing: 1,
                            fontWeight: FontWeight.w700,
                            // color: Color.fromRGBO(77, 32, 126, 1),
                            color: Colors.black,
                            fontFamily: 'DBHeavent'),
                      ),
                    ),
                    Container(
                      margin: EdgeInsets.only(top: 0),
                      child: Text(
                        item.time,
                        style: TextStyle(
                            fontSize: 18,
                            letterSpacing: 1,
                            fontWeight: FontWeight.w500,
                            color: Color.fromRGBO(77, 32, 126, 1),
                            // color: Colors.white,
                            fontFamily: 'DBHeavent'),
                      ),
                    )
                  ],
                )
              ],
            ),
          )
        ],
      ),
    );

class Model {
  String image, title, time;
  Model({required this.image, required this.title, required this.time});
}

List<Model> listitem = [
  Model(
      image:
          'https://images.unsplash.com/photo-1645894183288-9c43d07958fa?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHw2Mnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'รายการคุยถึงแก่นได้ Update วิดีโอตอนใหม่แล้ว',
      time: '15 นาทีที่ผ่านมา'),
  Model(
      image:
          'https://images.unsplash.com/photo-1645894183288-9c43d07958fa?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHw2Mnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'รายการคุยถึงแก่นได้ Update วิดีโอตอนใหม่แล้ว',
      time: '15 นาทีที่ผ่านมา'),
  Model(
      image:
          'https://images.unsplash.com/photo-1645894183288-9c43d07958fa?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHw2Mnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
      title: 'รายการคุยถึงแก่นได้ Update วิดีโอตอนใหม่แล้ว',
      time: '15 นาทีที่ผ่านมา'),
  Model(
    image:
        'https://images.unsplash.com/photo-1645894183288-9c43d07958fa?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxlZGl0b3JpYWwtZmVlZHw2Mnx8fGVufDB8fHx8&auto=format&fit=crop&w=600&q=60',
    title: 'รายการคุยถึงแก่นได้ Update วิดีโอตอนใหม่แล้ว',
    time: '15 นาทีที่ผ่านมา',
  ),
];
