import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_title.dart';
import 'package:nbt_app/screen/register/register_page.dart';

class TermPage extends StatefulWidget {
  const TermPage({Key? key}) : super(key: key);

  @override
  _TermPageState createState() => _TermPageState();
}

class _TermPageState extends State<TermPage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Scaffold(
      appBar: AppBar(
        elevation: 0.55,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: AppbarTitle(
          title: 'ลงทะเบียน / ยืนยันตัวตน',
        ),
      ),
      body: Stack(
        children: [
          Container(
            color: Color.fromRGBO(77, 32, 126, 1),
            height: 50.h,
          ),
          Container(
            margin: EdgeInsets.only(left: 15.h, right: 15.h),
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              border: Border.all(
                color: Colors.white,
                style: BorderStyle.solid,
                width: 1.0,
              ),
              color: Colors.white,
              borderRadius: BorderRadius.circular(10.0),
            ),
            child: Column(
              children: [
                Container(
                  padding: EdgeInsets.only(top: 20.h, left: 20.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "ยินดีต้อนรับเข้าสู่ระบบ สมัครสมาชิก ของ NBT",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 10.h, left: 20.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "๏ สิทธิพิเศษเฉพาะสมาชิก เท่านั้น",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 10.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "1. สามารถดูประวัติรับชมส่วนตัวได้\n2. สามารถบันทึกลิงก์รายการโปรดได้\n3. สามารถ Comment ขณะรับชมรายการต่างๆ ได้\n4. สิทธิร่วมรับของรางวัลในโอกาสจัดกิจกรรมพิเศษต่างๆ",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
              ],
            ),
          ),
          Expanded(child: Container()),
          btn(),
        ],
      ),
    );
  }

  Widget btn() {
    return Align(
      alignment: Alignment.bottomCenter,
      child: Container(
        width: 300.w,
        child: RaisedButton(
          shape: new RoundedRectangleBorder(
              borderRadius: new BorderRadius.circular(30.0)),
          child: Container(
            alignment: Alignment.center,
            height: 35.h,
            width: double.infinity,
            child: Text(
              "ตกลง",
              style: TextStyle(
                fontSize: 24,
                fontWeight: FontWeight.w500,
                fontFamily: 'DBHeavent',
                color: Colors.white,
              ),
            ),
          ),
          color: Color.fromRGBO(77, 32, 126, 1),
          onPressed: () {
            Navigator.pushReplacement(context,
                MaterialPageRoute(builder: (context) => RegisterPage()));
          },
        ),
      ),
    );
  }
}
