import 'dart:async';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:nbt_app/environment/base_presenter.dart';
import 'package:nbt_app/screen/home/home_page.dart';
import 'package:nbt_app/screen/splashscreen/splashscreen_page.dart';

class SplashScreenPresenter extends BasePresenter<SplashScreenPage> {
  SplashScreenPresenter(State<SplashScreenPage> state) : super(state);

  late Timer _timer;

  init() async {
    _timer = new Timer(
      Duration(seconds: 2),
      () async {
        Navigator.pushReplacement(
            state.context, CupertinoPageRoute(builder: (_) => HomePage()));
      },
    );
  }
}
