import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:nbt_app/components/appbar_title.dart';
import 'package:nbt_app/screen/login/login_page.dart';

class RegisterCompletePage extends StatefulWidget {
  const RegisterCompletePage({Key? key}) : super(key: key);

  @override
  _RegisterCompletePageState createState() => _RegisterCompletePageState();
}

class _RegisterCompletePageState extends State<RegisterCompletePage> {
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: AppBar(
        elevation: 0.55,
        shadowColor: Color.fromRGBO(77, 32, 126, 1),
        bottomOpacity: 0,
        backgroundColor: Color.fromRGBO(77, 32, 126, 1),
        toolbarHeight: 80.h,
        title: AppbarTitle(
          title: 'เงื่อนไขการให้บริการ',
        ),
      ),
      body: Stack(
        children: [
          Container(
            color: Color.fromRGBO(77, 32, 126, 1),
            height: 50.h,
          ),
          Container(
            margin: EdgeInsets.only(left: 15.h, right: 15.h),
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              border: Border.all(
                color: Colors.white,
                style: BorderStyle.solid,
                width: 1.0,
              ),
              color: Colors.white,
              borderRadius: BorderRadius.circular(10.0),
            ),
            child: Column(
              children: [
                Container(
                  padding: EdgeInsets.only(top: 20.h, left: 20.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "1. วัตถุประสงค์ของการเก็บรวบรวม ใช้ หรือเปิดเผย\nข้อมูลส่วนบุคคล เพื่อประโยชน์ต่อการให้บริการ ของ\nกรมประชาสัมพันธ์ ทั้งนี้",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 20.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "๏  ข้อมูลส่วนบุคคล",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 10.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "หมายความว่า ข้อมูลเกี่ยวกับบุคคลซึ่งทำให้สามารถระบุตัวบุคคลนั้นได้ไม่ว่าทางตรงหรือทางอ้อม อาทิเช่น ชื่อนามสกุล เพศ ที่อยู่ เบอร์โทรศัพท์ วัน เดือน ปี เกิด รูปถ่าย",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 20.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "๏  ผู้ควบคุมข้อมูลส่วนบุคคล",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 10.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "หมายความว่า บุคคลซึ่งมีอำนาจหน้าที่ตัดสินใจเกี่ยวกับการเก็บรวบรวม ใช้หรือเปิดเผยข้อมูลส่วนบุคคล",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 20.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "๏  ผู้ประมวลผลข้อมูลส่วนบุคคล",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(top: 10.h, left: 30.h),
                  alignment: Alignment.topLeft,
                  child: Text(
                    "หมายความว่า บุคคลซึ่งดำเนินการเกี่ยวกับการเก็บรวบรวม ใช้หรือเปิดเผยข้อมูลส่วนบุคคลตามคำสั่ง หรือในนามของผู้ควบคุมข้อมูลส่วนบุคคล ทั้งนี้ บุคคลซึ่งดำเนินการดังกล่าวไม่เป็นผู้ควบคุมข้อมูลส่วนบุคคล",
                    style: TextStyle(
                      fontSize: 22,
                      fontWeight: FontWeight.w500,
                      fontFamily: 'DBHeavent',
                      color: Colors.black87,
                    ),
                  ),
                ),
                Expanded(child: Container()),
                Row(
                  children: [
                    Spacer(),
                    btnCancel(),
                    Spacer(),
                    btnOk(),
                    Spacer(),
                  ],
                ),
                SizedBox(
                  height: 30.h,
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget btnOk() {
    return Align(
      alignment: Alignment.bottomCenter,
      child: Container(
        width: 150.w,
        child: RaisedButton(
          shape: new RoundedRectangleBorder(
              borderRadius: new BorderRadius.circular(30.0)),
          child: Container(
            alignment: Alignment.center,
            height: 35.h,
            width: double.infinity,
            child: Text(
              "ยินยอม",
              style: TextStyle(
                fontSize: 24,
                fontWeight: FontWeight.w500,
                fontFamily: 'DBHeavent',
                color: Colors.white,
              ),
            ),
          ),
          color: Color.fromRGBO(77, 32, 126, 1),
          onPressed: () {
            Navigator.pushReplacement(
                context, MaterialPageRoute(builder: (context) => LoginPage()));
          },
        ),
      ),
    );
  }

  Widget btnCancel() {
    return Align(
      alignment: Alignment.bottomCenter,
      child: Container(
        width: 150.w,
        child: RaisedButton(
          shape: new RoundedRectangleBorder(
              borderRadius: new BorderRadius.circular(30.0)),
          child: Container(
            alignment: Alignment.center,
            height: 35.h,
            width: double.infinity,
            child: Text(
              "ไม่ยินยอม",
              style: TextStyle(
                fontSize: 24,
                fontWeight: FontWeight.w500,
                fontFamily: 'DBHeavent',
                color: Colors.white,
              ),
            ),
          ),
          color: Color.fromRGBO(255, 186, 0, 1),
          onPressed: () {
            Navigator.pop(context);
            // Navigator.pushReplacement(context,
            //     MaterialPageRoute(builder: (context) => RegisterPage()));
          },
        ),
      ),
    );
  }
}
