import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class FavouriteListPage extends StatefulWidget {
  const FavouriteListPage({Key? key}) : super(key: key);

  @override
  State<FavouriteListPage> createState() => _FavouriteListPageState();
}

class _FavouriteListPageState extends State<FavouriteListPage>
    with SingleTickerProviderStateMixin {
  late TabController tabcontroller;
  @override
  void initState() {
    tabcontroller = TabController(length: 2, vsync: this);
    super.initState();
  }

  @override
  void dispose() {
    tabcontroller.dispose();
    super.dispose();
  }

  Widget build(BuildContext context) {
    // TabController _tabontroller = TabController(length: 2, vsync: );
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
        debugShowCheckedModeBanner: false,
        home: Scaffold(
            appBar: AppBar(
              elevation: 0.55,
              shadowColor: Color.fromRGBO(77, 32, 126, 1),
              bottomOpacity: 0,
              backgroundColor: Color.fromRGBO(77, 32, 126, 1),
              toolbarHeight: 80.h,
              title: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Container(
                      margin: EdgeInsets.only(top: 10),
                      child: GestureDetector(
                          onTap: () {
                            Navigator.pop(context);
                          },
                          child: Icon(Icons.arrow_back_ios))),
                  SizedBox(
                    width: 115,
                  ),
                  Container(
                    margin: EdgeInsets.only(top: 10),
                    child: Text(
                      'รายการโปรด',
                      style: TextStyle(
                          fontFamily: 'DBHeavent',
                          fontSize: 30,
                          color: Colors.white),
                    ),
                  )
                ],
              ),
            ),
            body: Container(
                width: MediaQuery.of(context).size.width,
                height: MediaQuery.of(context).size.height,
                child: Stack(children: [
                  Container(
                    color: Color.fromRGBO(77, 32, 126, 1),
                    height: 60.h,
                  ),
                  Container(
                    padding: EdgeInsets.only(top: 20, left: 20, right: 20),
                    margin: EdgeInsets.only(left: 15, right: 15),
                    height: 550,
                    width: 400,
                    decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(10),
                        boxShadow: [
                          BoxShadow(
                              color: Colors.black.withOpacity(0.1),
                              spreadRadius: 3,
                              blurRadius: 6)
                        ]),
                    child: Column(
                      children: [
                        Container(
                          padding: EdgeInsets.only(
                              left: 5, right: 5, top: 5, bottom: 5),
                          color: Color.fromRGBO(244, 244, 244, 100),
                          height: 40.h,
                          child: TabBar(
                              labelColor: Color.fromRGBO(77, 37, 124, 1),
                              unselectedLabelColor:
                                  Color.fromRGBO(177, 177, 177, 1),
                              indicatorColor: Colors.white,
                              indicatorWeight: 2,
                              indicator: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(5)),
                              controller: tabcontroller,
                              tabs: [
                                Tab(
                                  child: Text(
                                    'วิดีโอที่ชอบ',
                                    style: TextStyle(
                                      fontFamily: 'DBHeavent',
                                      fontSize: 20,
                                    ),
                                  ),
                                ),
                                Tab(
                                  child: Text(
                                    'รายการโปรด',
                                    style: TextStyle(
                                      fontFamily: 'DBHeavent',
                                      fontSize: 20,
                                    ),
                                  ),
                                ),
                              ]),
                        ),
                        // Container(
                        //   color: Colors.red,
                        //   margin: EdgeInsets.only(top: 10),
                        //   height: 460,
                        //   child: GridView.builder(
                        //       itemCount: favouritevideoItems.length,
                        //       gridDelegate:
                        //           SliverGridDelegateWithFixedCrossAxisCount(
                        //               crossAxisCount: 2,
                        //               crossAxisSpacing: 11.42,
                        //               mainAxisSpacing: 0),
                        //       itemBuilder: (context, index) {
                        //         return buildvideo_Card(
                        //             data: favouritelistItems[index]);
                        //       }),
                        // )
                        Container(
                          height: 470,
                          child:
                              TabBarView(controller: tabcontroller, children: [
                            Container(
                              margin: EdgeInsets.only(top: 10),
                              height: 460,
                              child: GridView.builder(
                                  itemCount: favouritevideoItems.length,
                                  gridDelegate:
                                      SliverGridDelegateWithFixedCrossAxisCount(
                                          crossAxisCount: 2,
                                          crossAxisSpacing: 11.42,
                                          mainAxisSpacing: 0),
                                  itemBuilder: (context, index) {
                                    return buildvideo_Card(
                                        data: favouritevideoItems[index]);
                                  }),
                            ),
                            Container(
                              margin: EdgeInsets.only(top: 10),
                              height: 460,
                              child: GridView.builder(
                                  itemCount: favouritevideoItems.length,
                                  gridDelegate:
                                      SliverGridDelegateWithFixedCrossAxisCount(
                                          crossAxisCount: 2,
                                          crossAxisSpacing: 11.42,
                                          mainAxisSpacing: 0),
                                  itemBuilder: (context, index) {
                                    return buildfavourite_Card(
                                        data: favouritelistItems[index]);
                                  }),
                            )
                          ]),
                        )
                      ],
                    ),
                  )
                ]))));
  }
}

Widget buildvideo_Card({required Model data}) => Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          width: 165,
          height: 95,
          child: ClipRRect(
            borderRadius: BorderRadius.circular(5),
            child: Image.network(
              data.url,
              fit: BoxFit.cover,
            ),
          ),
        ),
        Row(
          children: [
            Text(
              data.date,
              style: TextStyle(
                  color: Color.fromRGBO(161, 159, 163, 1),
                  fontSize: 17,
                  fontFamily: 'DBHeavent'),
            ),
            SizedBox(
              width: 3,
            ),
            Icon(
              Icons.remove_red_eye_outlined,
              color: Color.fromRGBO(161, 159, 163, 1),
              size: 13,
            ),
            SizedBox(
              width: 3,
            ),
            Text(data.view,
                style: TextStyle(
                    color: Color.fromRGBO(161, 159, 163, 1),
                    fontSize: 17,
                    fontFamily: 'DBHeavent')),
          ],
        ),
        Text(
          data.des,
          maxLines: 2,
          softWrap: true,
          style: TextStyle(
              height: 0.9,
              color: Colors.black,
              fontSize: 20,
              fontFamily: 'DBHeavent'),
        )
      ],
    );
Widget buildfavourite_Card({required Model data}) => Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          width: 165,
          height: 95,
          child: ClipRRect(
            borderRadius: BorderRadius.circular(5),
            child: Image.network(
              data.url,
              fit: BoxFit.cover,
            ),
          ),
        ),
        Row(
          children: [
            Text(
              data.date,
              style: TextStyle(
                  color: Color.fromRGBO(161, 159, 163, 1),
                  fontSize: 17,
                  fontFamily: 'DBHeavent'),
            ),
            SizedBox(
              width: 3,
            ),
            Icon(
              Icons.remove_red_eye_outlined,
              color: Color.fromRGBO(161, 159, 163, 1),
              size: 13,
            ),
            SizedBox(
              width: 3,
            ),
            Text(data.view,
                style: TextStyle(
                    color: Color.fromRGBO(161, 159, 163, 1),
                    fontSize: 17,
                    fontFamily: 'DBHeavent')),
          ],
        ),
        Text(
          data.des,
          maxLines: 2,
          softWrap: true,
          style: TextStyle(
              height: 0.9,
              color: Colors.black,
              fontSize: 20,
              fontFamily: 'DBHeavent'),
        )
      ],
    );

class Model {
  String url, title, date, view, des;

  Model(
      {required this.url,
      required this.title,
      required this.date,
      required this.view,
      required this.des});
}

List<Model> favouritelistItems = [
  Model(
      url: 'https://ophtus.com/wp-content/uploads/2017/11/UL7539-main-1.jpg',
      title: 'title1',
      date: '15 ม.ค. 20',
      view: '100',
      des:
          'Ophtus เผย ทางจุฬาฯ ไม่ให้ขึ้นรูปพรีเซนเตอร์บนบิลบอร์ดและให้เปลี่ยนไปเป็นรูปอื่นแทน fghfgjf'),
  Model(
      url:
          'https://images.unsplash.com/photo-1538481199705-c710c4e965fc?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8Z2FtaW5nfGVufDB8fDB8fA%3D%3D&auto=format&fit=crop&w=400&q=60',
      title: 'title2',
      date: '20 พ.ค. 20',
      view: '200',
      des:
          'สาวก FromSoftware ลั่น ที่เคยบอกมือใหม่ก็เล่น Elden Ring ได้สบาย มันไม่จริง!'),
  Model(
      url:
          'https://images.unsplash.com/photo-1593305841991-05c297ba4575?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NXx8Z2FtaW5nfGVufDB8fDB8fA%3D%3D&auto=format&fit=crop&w=400&q=60',
      title: 'title3',
      date: '54 ก.ย. 20',
      view: '300',
      des:
          'สาวก FromSoftware ลั่น ที่เคยบอกมือใหม่ก็เล่น Elden Ring ได้สบาย มันไม่จริง!'),
  Model(
      url:
          'https://images.unsplash.com/photo-1580234811497-9df7fd2f357e?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8MTF8fGdhbWluZ3xlbnwwfHwwfHw%3D&auto=format&fit=crop&w=400&q=60',
      title: 'title4',
      date: '20 ส.ค. 20',
      view: '400',
      des:
          'X10CRIT ถูกตัดสิทธิ์ หลังทำผิดกฎการแข่ง VALORANT Champions Tour 2022'),
  Model(
      url:
          'https://images.unsplash.com/photo-1560253023-3ec5d502959f?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8MTd8fGdhbWluZ3xlbnwwfHwwfHw%3D&auto=format&fit=crop&w=400&q=60',
      title: 'TITLEEEEE',
      date: '20 ม.ค. 21',
      view: '4165',
      des:
          'HTC อาจจะมีการเปิดตัวสมาร์ทโฟนที่มาพร้อมฟังก์ชัน Metaverse ในเดือนเมษายนนี้!')
];
List<Model> favouritevideoItems = [
  Model(
      url:
          'https://media.istockphoto.com/photos/coronavirus-new-strain-wide-dark-background-picture-id1308624310?b=1&k=20&m=1308624310&s=170667a&w=0&h=HyEGR3DtK8TD2_kqoryPPuBWexQnG_KK0KhHYtXvm-c=',
      title: 'title1',
      date: '15 ม.ค. 20',
      view: '100',
      des: 'สถานการณ์ COVID-19 ในประเทศไทย'),
  Model(
      url:
          'https://media.istockphoto.com/photos/asian-woman-holding-covid-rapid-test-and-waiting-for-results-picture-id1345296778?b=1&k=20&m=1345296778&s=170667a&w=0&h=jSixqhOleGak2Z9xEXcjNYZ1cUqLm5J8LKzbBVMf2Cg=',
      title: 'title2',
      date: '20 พ.ค. 20',
      view: '200',
      des:
          'โควิดวันนี้ เสียชีวิตนิวไฮ ป่วยใหม่พุ่ง2.3หมื่น เข้าข่ายATK ทะลุ3.1หมื่น'),
  Model(
      url:
          'https://media.istockphoto.com/photos/medical-worker-wearing-personal-protective-equipment-doing-corona-picture-id1297810407?b=1&k=20&m=1297810407&s=170667a&w=0&h=1v5rc9sDIJvyjESAhNDksU2_oDKvUPbcEqYYVqYikEw=',
      title: 'title3',
      date: '54 ก.ย. 20',
      view: '300',
      des: 'อาการโควิดโอมิครอน เช็กเลยติดแล้วป่วยแบบไหน'),
  Model(
      url:
          'https://images.unsplash.com/photo-1584483766114-2cea6facdf57?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NXx8Y292aWQlMjAxOXxlbnwwfHwwfHw%3D&auto=format&fit=crop&w=400&q=60',
      title: 'title4',
      date: '20 ส.ค. 20',
      view: '400',
      des:
          'ยอดดับเพิ่มอีก! โควิดวันนี้ ไทยพบผู้ติดเชื้อใหม่ 23,834 ราย เสียชีวิตอีก 54 ราย'),
  Model(
      url:
          'https://images.unsplash.com/photo-1605289982774-9a6fef564df8?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8Y292aWQlMjAxOXxlbnwwfHwwfHw%3D&auto=format&fit=crop&w=400&q=60',
      title: 'TITLEEEEE',
      date: '20 ม.ค. 21',
      view: '4165',
      des:
          'โควิดวันนี้ (3 มี.ค.) ศบค.พบป่วยใหม่ 23,618 ราย+ATK พุ่งกระฉูด 42,138 คน')
];
