import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class EditPassword_Page extends StatefulWidget {
  const EditPassword_Page({Key? key}) : super(key: key);

  @override
  State<EditPassword_Page> createState() => _EditPassword_PageState();
}

class _EditPassword_PageState extends State<EditPassword_Page> {
  bool _check1 = true;
  bool _check2 = true;
  bool _check3 = true;
  RegExp regex = RegExp(r'^(?=.*?[a-z])(?=.*?[0-9])');
  String? oldpass, newpass, comfirmpass;
  TextEditingController _controllerold = new TextEditingController();
  TextEditingController _controllernew = new TextEditingController();
  TextEditingController _controllercomfirm = new TextEditingController();
  final _key = GlobalKey<FormState>();
  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        resizeToAvoidBottomInset: true,
        appBar: AppBar(
          elevation: 0.55,
          shadowColor: Color.fromRGBO(77, 32, 126, 1),
          bottomOpacity: 0,
          backgroundColor: Color.fromRGBO(77, 32, 126, 1),
          toolbarHeight: 80.h,
          title: Row(mainAxisAlignment: MainAxisAlignment.start, children: [
            Container(
                margin: EdgeInsets.only(top: 10),
                child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: Icon(Icons.arrow_back_ios))),
            SizedBox(
              width: 115,
            ),
            Text('แก้ไข้รหัสผ่าน',
                style: TextStyle(
                    fontFamily: 'DBHeavent',
                    fontSize: 28,
                    color: Colors.white)),
          ]),
        ),
        body: SizedBox(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          child: Stack(children: [
            Container(
              color: Color.fromRGBO(77, 32, 126, 1),
              height: 60.h,
            ),
            SingleChildScrollView(
              child: Container(
                padding: EdgeInsets.only(top: 20, left: 20, right: 20),
                margin: EdgeInsets.only(left: 15, right: 15, bottom: 40),
                width: 400.h,
                height: 540.h,
                decoration: BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.circular(10),
                    boxShadow: [
                      BoxShadow(
                          color: Colors.black.withOpacity(0.1),
                          spreadRadius: 3,
                          blurRadius: 6)
                    ]),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                      padding: EdgeInsets.only(
                        left: 5,
                        right: 5,
                        top: 5,
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Form(
                            key: _key,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  'รหัสผ่านปัจจุบัน',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 23,
                                    color: Color.fromRGBO(77, 37, 124, 1),
                                  ),
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                Container(
                                  child: TextField(
                                    controller: _controllerold,
                                    onChanged: (value) {
                                      setState(() {
                                        this.oldpass = value;
                                        print(value);
                                      });
                                    },
                                    obscureText: _check1,
                                    decoration: InputDecoration(
                                        suffixIcon: GestureDetector(
                                          onTap: () {
                                            setState(() {
                                              _check1 = !_check1;
                                            });
                                          },
                                          child: Icon(_check1
                                              ? Icons.visibility_off_outlined
                                              : Icons.visibility_outlined),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        filled: true,
                                        contentPadding: EdgeInsets.only(
                                          left: 25,
                                        ),
                                        focusedBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        hintStyle: TextStyle(
                                          color: Colors.grey,
                                          fontFamily: 'DBHeavent',
                                          fontSize: 23,
                                        ),
                                        hintText: 'กรอกรหัสผ่าน',
                                        fillColor: Colors.white),
                                  ),
                                ),
                                SizedBox(
                                  height: 20,
                                ),
                                Text(
                                  'รหัสผ่านใหม่',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 23,
                                    color: Color.fromRGBO(77, 37, 124, 1),
                                  ),
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                Container(
                                  child: TextFormField(
                                    validator: (value) {
                                      if (value!.isEmpty) {
                                        return "Required";
                                      } else {
                                        return null;
                                      }
                                    },
                                    onChanged: (value) {
                                      setState(() {
                                        this.newpass = value;
                                      });
                                    },
                                    controller: _controllernew,
                                    obscureText: _check2,
                                    decoration: InputDecoration(
                                        suffixIcon: GestureDetector(
                                          onTap: () {
                                            setState(() {
                                              _check2 = !_check2;
                                            });
                                          },
                                          child: Icon(_check2
                                              ? Icons.visibility_off_outlined
                                              : Icons.visibility_outlined),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        filled: true,
                                        contentPadding: EdgeInsets.only(
                                          left: 25,
                                        ),
                                        focusedBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        hintStyle: TextStyle(
                                          color: Colors.grey,
                                          fontFamily: 'DBHeavent',
                                          fontSize: 23,
                                        ),
                                        hintText:
                                            'กรุณาใส่ 6-20 ที่มีทั้งตัวอักษรและตัวเลข',
                                        fillColor: Colors.white),
                                  ),
                                ),
                                SizedBox(
                                  height: 20,
                                ),
                                Text(
                                  'ยืนยันรหัสผ่านใหม่',
                                  style: TextStyle(
                                    fontFamily: 'DBHeavent',
                                    fontSize: 23,
                                    color: Color.fromRGBO(77, 37, 124, 1),
                                  ),
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                Container(
                                  child: TextField(
                                    onChanged: (value) {
                                      setState(() {
                                        this.comfirmpass = value;
                                      });
                                    },
                                    controller: _controllercomfirm,
                                    obscureText: _check3,
                                    decoration: InputDecoration(
                                        suffixIcon: GestureDetector(
                                          onTap: () {
                                            setState(() {
                                              _check3 = !_check3;
                                            });
                                          },
                                          child: Icon(_check3
                                              ? Icons.visibility_off_outlined
                                              : Icons.visibility_outlined),
                                        ),
                                        border: OutlineInputBorder(
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        filled: true,
                                        contentPadding: EdgeInsets.only(
                                          left: 25,
                                        ),
                                        focusedBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        enabledBorder: OutlineInputBorder(
                                          borderSide:
                                              BorderSide(color: Colors.grey),
                                          borderRadius:
                                              BorderRadius.circular(30),
                                        ),
                                        hintStyle: TextStyle(
                                          color: Colors.grey,
                                          fontFamily: 'DBHeavent',
                                          fontSize: 23,
                                        ),
                                        hintText:
                                            'กรุณายืนยันรหัสผ่านของคุณอีกครั้ง',
                                        fillColor: Colors.white),
                                  ),
                                ),
                                SizedBox(
                                  height: 155,
                                ),
                                GestureDetector(
                                  onTap: () {
                                    if (this.oldpass == "") {
                                    } else if (this.newpass == "") {
                                      print('object');
                                    } else if (this.comfirmpass == "" &&
                                        this.comfirmpass == this.newpass) {}
                                  },
                                  child: Container(
                                    height: 50,
                                    width: MediaQuery.of(context).size.width,
                                    decoration: BoxDecoration(
                                        gradient: LinearGradient(
                                            colors: [
                                              Color.fromRGBO(122, 79, 159, 1),
                                              Color.fromRGBO(77, 32, 126, 1)
                                            ],
                                            begin: Alignment.topCenter,
                                            end: Alignment.bottomCenter),
                                        color: Color.fromRGBO(77, 37, 124, 1),
                                        borderRadius:
                                            BorderRadius.circular(30)),
                                    child: Center(
                                      child: Text(
                                        'ยืนยัน',
                                        style: TextStyle(
                                          fontFamily: 'DBHeavent',
                                          fontSize: 25,
                                          color: Colors.white,
                                        ),
                                      ),
                                    ),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ]),
        ),
      ),
    );
  }
}
