import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class AppbarTitle extends StatelessWidget {
  // const AppbarTitle({required this.title}) : super(key: title);

  AppbarTitle({
    required this.title,
    Key? key,
  }) : super(key: key);
  String title;

  @override
  Widget build(BuildContext context) {
    ScreenUtil.init(
        BoxConstraints(
            maxWidth: MediaQuery.of(context).size.width,
            maxHeight: MediaQuery.of(context).size.height),
        designSize: Size(360, 690),
        context: context,
        minTextAdapt: true,
        orientation: Orientation.portrait);
    return Container(
      // alignment: Alignment.topCenter,
      child: Text(
        "${title}",
        style: TextStyle(
          color: Colors.white,
          fontFamily: 'DBHeavent',
          fontSize: 25,
          fontWeight: FontWeight.w500,
          letterSpacing: 1,
        ),
      ),
    );
  }
}
